/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.sound;

import java.util.Properties;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.StatConAlertActionProvider;

public class SoundActionProvider implements StatConAlertActionProvider {
	public static final String PREFS = "STATCON_ACTION_SOUND__";
	public static final String PATH = "path";
	
	public String getName() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_SOUND");
	}
	public AlertAction newAlertAction() {
		return new SoundAlertAction();
	}
	public AlertAction fromProperties(Properties props) {
		SoundAlertAction a = new SoundAlertAction();
		a.path = props.getProperty(PREFS+PATH);
		return a;
	}
	public void toProperties(Properties props, AlertAction action) {
		SoundAlertAction a = (SoundAlertAction)action;
		props.setProperty(PREFS+PATH,a.path);
	}
}

