/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public interface Graph {

	public static final int PLOTTING_TYPE_AVERAGE = 0;
	public static final int PLOTTING_TYPE_MIN = 1;
	public static final int PLOTTING_TYPE_MAX = 2;
	public static final int PLOTTING_TYPE_MIN_MAX = 3;
	public static final int PLOTTING_TYPE_MIN_MAX_AVERAGE = 4;
	public static final int PLOTTING_TYPE_SUM = 5;
	public static final int PLOTTING_TYPE_NEAREST = 6;
	public static final int PLOTTING_TYPE_COUNT = 7;
	public static final int PLOTTING_TYPE_STDDEV = 8;
	public static final int PLOTTING_TYPE_STDDEV_AVERAGE = 9;
	public static final int PLOTTING_TYPE_GRADIENT = 10;
	
	public static final int PERIOD_TYPE_TICKS = 0;
	public static final int PERIOD_TYPE_MILLIS = 1;
	public static final int PERIOD_TYPE_PIXELS = 2;
	public static final int PERIOD_TYPE_UNAVERAGED = 3;
	
	public static final int NODATA_DO_NOTHING = 0;
	public static final int NODATA_DRAW_ZERO = 1;
	public static final int NODATA_DRAW_PREVIOUS = 2;

	public BasicGraphSource getGraphSource();

	public double getXMin();
	public double getXMax();
	public double getYMin();
	public double getYMax();
	public void paintGraph(GC gc, int x, int y, int w, int h);
	public void setXSlider(TimeZoomSlider slider);
	public void setYSlider(ZoomSlider slider);
	public TimeZoomSlider getXSlider();
	public ZoomSlider getYSlider();
	public void setForeground(Color col);
	public Color getForeground();
	public void setLineWidth(int w);
	public int getLineWidth();
	public void setLineStyle(int swt_line_style);
	public int getLineStyle();
	public void setStaticScaling(double mult); 
	public double getStaticScaling(); 
	
	public int getPlottingType();
	public void setPlottingType(int type);
	
	public int getNoDataBehaviour();
	public void setNoDataBehaviour(int behaviour);
	
	public void setPlottingPeriod(int type, double value);
	public int getPlottingPeriodType();
	public double getPlottingPeriodValue();
	
	public void setXOffset(double millis);
	public double getXOffset();
	
	public void setYOffset(double millis);
	public double getYOffset();
	
	public void setUseIndicator(boolean b);
	public void setIndicatorSource(IndicatorSource isource);
	
	
}