/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class IndicatorLineGraph implements TextGraph, IndicatorSource {
	
	int type = TYPE_TIME;
	
	TimeZoomSlider xslider;
	ZoomSlider yslider;
	
	Color black_color;
	
	Color fg_col;
	int line_width = 1;

	int line_style = SWT.LINE_SOLID;
	
	double source_val = Double.MAX_VALUE;
	
	public double getIndicatorLocation() {
		return source_val;	
	}

	public void setIndicatorSource(IndicatorSource isource) {
	}
	
	/**
	 * Graphs the reference lines for a pair of sliders
	 */
	public IndicatorLineGraph(TimeZoomSlider xslider, ZoomSlider yslider, Color col) {
		this.xslider = xslider;
		this.yslider = yslider;
		
		this.fg_col = col;
	}
	
	public BasicGraphSource getGraphSource() {
		return null;	
	}

	public double getXMin() {
		return Double.NEGATIVE_INFINITY;		
	}

	public double getXMax() {
		return Double.POSITIVE_INFINITY;
	}

	public double getYMin() {
		return Double.NEGATIVE_INFINITY;		
	}

	public double getYMax() {
		return Double.POSITIVE_INFINITY;		
	}

	public TimeZoomSlider getXSlider() {
		return xslider;	
	}

	public ZoomSlider getYSlider() {
		return yslider;	
	}	
	public void setXSlider(TimeZoomSlider slider) {
		xslider = slider;
	}
	
	public void setYSlider(ZoomSlider slider) {
		yslider = slider;
	}	
	
	public void setForeground(Color col) {
		fg_col = col;
	}
	
	public Color getForeground() {
		return fg_col;
	}
	
	public void setLineWidth(int w) {
		line_width = w;
	}
	
	public int getLineWidth() {
		return line_width;
	}

	public void setLineStyle(int swt_line_style) {
		line_style = swt_line_style;
	}
	
	public int getLineStyle() {
		return line_style;	
	}
	
	public void setUseIndicator(boolean b) {
	}

	public int getSourceType() {
		return type;
	}

	public void setSourceType(int t) {
		type = t;	
	}

	public void setIndicatorLocation(double d) {
		source_val = d;
	}

	public void paintGraph(GC gc, int x, int y, int w, int h) {
		paintGraph(gc,x,y,w,h,0);
	}

	public int paintGraph(GC gc, int x, int y, int w, int h, int yoffset) {

		int fheight = gc.getFontMetrics().getHeight();

		gc.setForeground(fg_col);
		gc.setLineWidth(line_width);	
		gc.setLineStyle(line_style);

		int xval = (int)source_val;
		long t = (long)xslider.pixel2Value(xval);
		if (type == TYPE_TIME) {
			xval = (int)xslider.value2Pixel(source_val);
			t = (long)source_val;
		}

		//simple bounds check
		if (xval < w) {
		
			gc.drawLine(xval,y,xval,y+h);
	
			SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
	
			StringBuffer str = new StringBuffer();
			str.append(sdf.format(new Date(t)));

			gc.setForeground(yslider.getDisplay().getSystemColor(SWT.COLOR_GRAY));
			gc.drawString(str.toString(),xval+2,yoffset + y+1,true);

			try {
				gc.setForeground(yslider.getDisplay().getSystemColor(SWT.COLOR_BLACK));
			} catch (Throwable xx) {
				if (black_color == null) { 
				    black_color = new Color(yslider.getDisplay(),0,0,0);
				}
				gc.setForeground(black_color);
			}
			gc.drawString(str.toString(),xval+1,yoffset + y,true);
	
			yoffset += fheight;
		
			if ((yoffset + fheight) > h) {
				yoffset = 0;
			}	
		}

		return yoffset;
	}
	
	public void setStaticScaling(double mult) {
	}
	public double getStaticScaling() {
		return 1.0;
	} 
	
		public int getPlottingType() {
		return Graph.PLOTTING_TYPE_AVERAGE;
	}
	public void setPlottingType(int type) {
	}
	
	public void setPlottingPeriod(int type, double value) {
	}
	public int getPlottingPeriodType() {
		return Graph.PERIOD_TYPE_TICKS;
	}
	public double getPlottingPeriodValue() {
		return 1.0;
	}
	
	public void setXOffset(double millis) {
	}
	public double getXOffset() {
		return 0;
	}
	
	public void setYOffset(double millis) {
	}
	public double getYOffset() {
		return 0;
	}	
	public int getNoDataBehaviour() {
		return Graph.NODATA_DO_NOTHING;
	}
	public void setNoDataBehaviour(int i) {
	}

}