/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.util.Vector;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSliderTick;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderTick;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class ReferenceLineGraph implements Graph {
	
	TimeZoomSlider xslider;
	ZoomSlider yslider;
	
	Color fg_col;
	int line_width = 1;

	boolean major;
	
	int line_style = SWT.LINE_DOT;
	
	/**
	 * Graphs the reference lines for a pair of sliders
	 */
	public ReferenceLineGraph(TimeZoomSlider xslider, ZoomSlider yslider, Color col, boolean major) {
		this.xslider = xslider;
		this.yslider = yslider;
		
		this.fg_col = col;
		this.major = major;
	}

	public BasicGraphSource getGraphSource() {
		return null;	
	}
	
	public void setIndicatorSource(IndicatorSource isource) {
	}

	public double getXMin() {
		return Double.NEGATIVE_INFINITY;		
	}

	public double getXMax() {
		return Double.POSITIVE_INFINITY;
	}

	public double getYMin() {
		return Double.NEGATIVE_INFINITY;		
	}

	public double getYMax() {
		return Double.POSITIVE_INFINITY;		
	}

	public TimeZoomSlider getXSlider() {
		return xslider;	
	}

	public ZoomSlider getYSlider() {
		return yslider;	
	}	
	public void setXSlider(TimeZoomSlider slider) {
		xslider = slider;
	}
	
	public void setYSlider(ZoomSlider slider) {
		yslider = slider;
	}	
	
	public void setForeground(Color col) {
		fg_col = col;
	}
	
	public Color getForeground() {
		return fg_col;
	}
	
	public void setLineWidth(int w) {
		line_width = w;
	}
	
	public int getLineWidth() {
		return line_width;
	}

	public void setLineStyle(int swt_line_style) {
		line_style = swt_line_style;
	}
	
	public int getLineStyle() {
		return line_style;	
	}
	
	public void setUseIndicator(boolean b) {
	}

	public void paintGraph(GC gc, int xorigin, int yorigin, int w, int h) {

//		int xorigin = x;
//		int yorigin = y;
		
		gc.setForeground(fg_col);
		gc.setLineWidth(line_width);	
		gc.setLineStyle(line_style);

		Vector yticks = yslider.getTickVector();

		double xres = xslider.getIncrement();
		double yres = yslider.getIncrement();
		
		double ystart = yslider.getMinVisible()-yres;
		double yend = yslider.getMaxVisible()+yres;
//		double ystart = yslider.pixel2Value(y)-yres;
//		double yend = yslider.pixel2Value(y+h)+yres;

		Vector xticks = xslider.getTickVector();

		double xstart = xslider.getMinVisible()-xres;
		double xend = xslider.getMaxVisible()+xres;
//		double xstart = xslider.pixel2Value(x)-xres;
//		double xend = xslider.pixel2Value(x+w)+xres;

		int px1, px2, py1, py2;

		px1 = (int)xslider.value2Pixel(xstart);
		px2 = (int)xslider.value2Pixel(xend);
		for (int tick = 0; tick < yticks.size(); tick++) {
			ZoomSliderTick ytick = (ZoomSliderTick)yticks.get(tick);
			if (ytick.textVisible && major) {
				py1 = (int)yslider.value2Pixel(ytick.value);
				gc.drawLine(xorigin+px1,yorigin+py1,xorigin+px2,yorigin+py1);		
			} else if (!ytick.textVisible && !major) {
				py1 = (int)yslider.value2Pixel(ytick.value);
				gc.drawLine(xorigin+px1,yorigin+py1,xorigin+px2,yorigin+py1);		
			}
		}

		py1 = (int)yslider.value2Pixel(ystart);
		py2 = (int)yslider.value2Pixel(yend);
		for (int tick = 0; tick < xticks.size(); tick++) {
			TimeZoomSliderTick xtick = (TimeZoomSliderTick)xticks.get(tick);
			if (xtick.textVisible && major) {
				px1 = (int)xslider.value2Pixel(xtick.value);
				gc.drawLine(xorigin+px1,yorigin+py1,xorigin+px1,yorigin+py2);
			} else if (!xtick.textVisible && !major) {
				px1 = (int)xslider.value2Pixel(xtick.value);
				gc.drawLine(xorigin+px1,yorigin+py1,xorigin+px1,yorigin+py2);
			}

		}
/*
		//
		// horizontal lines
		//
		px1 = (int)xslider.value2Pixel(xstart);
		px2 = (int)xslider.value2Pixel(xend);
		for (double ypos = ystart; ypos <= yend; ypos += yres) {
			
			py1 = (int)yslider.value2Pixel(ypos);
			gc.drawLine(px1,py1,px2,py1);		
				
		}

		py1 = (int)yslider.value2Pixel(ystart);
		py2 = (int)yslider.value2Pixel(yend);
		for (double xpos = xstart; xpos <= xend; xpos += xres) {
			
			px1 = (int)xslider.value2Pixel(xpos);
			gc.drawLine(px1,py1,px1,py2);
				
		}
*/
	}
	
	public void setStaticScaling(double mult) {
	}
	public double getStaticScaling() {
		return 1.0;
	} 
	
		public int getPlottingType() {
		return Graph.PLOTTING_TYPE_AVERAGE;
	}
	public void setPlottingType(int type) {
	}
	
	public void setPlottingPeriod(int type, double value) {
	}
	public int getPlottingPeriodType() {
		return Graph.PERIOD_TYPE_TICKS;
	}
	public double getPlottingPeriodValue() {
		return 1.0;
	}
	
	public void setXOffset(double millis) {
	}
	public double getXOffset() {
		return 0;
	}
	
	public void setYOffset(double millis) {
	}
	public double getYOffset() {
		return 0;
	}		
	public int getNoDataBehaviour() {
		return Graph.NODATA_DO_NOTHING;
	}
	public void setNoDataBehaviour(int i) {
	}

}