/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.internal;

//import java.net.MalformedURLException;
//import java.net.URL;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

//import org.eclipse.hyades.statistical.ui.*;

public class BaseImageManager {
//	private URL iconBaseURL;
	private ImageRegistry imageRegistry;
	private boolean loaded = false;

	protected AbstractUIPlugin plugin;
	protected String pluginID;
	String basePrefix;
	
	public BaseImageManager() {
	}

	class InitThread implements Runnable {
		public void run() {
			imageRegistry = plugin.getImageRegistry();
		}
	}
	
	/**
	 * This method should be overridden by subclasses
	 *
	 */
	protected void addImages() {
	}
	
	public void initialize(String basePrefix, AbstractUIPlugin plugin, String pluginID) {
		this.basePrefix = basePrefix;
		this.plugin = plugin;
		this.pluginID = pluginID;
		
		Display display = Display.getDefault();
		if (display == null) {
			display = Display.getCurrent();
		}
		
		display.syncExec(new InitThread());
//		imageRegistry = plugin.getImageRegistry();
	}

	private void loadImages() {
		if (!loaded) {
			addImages();
			loaded = true;
		}
	}
	
	protected void add(String prefix, String name) {
		imageRegistry.put(name,AbstractUIPlugin.imageDescriptorFromPlugin(pluginID,basePrefix+prefix+"/"+name));
	}

	public ImageDescriptor getImageDescriptor(String key) {
		loadImages();
		return (ImageDescriptor)imageRegistry.getDescriptor(key);	
	}
	
	public Image getImage(String key) {
		loadImages();
		return imageRegistry.get(key);
	}

}
