/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.spinner.internal;


import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DateDialog extends Dialog {

boolean DEBUG = true;

Shell shell;

Composite main_panel;

DateSpinner date_panel;

Composite button_panel;
Button cancel_button;
Button ok_button;

boolean ok = false;

long thedate = 0;

	public DateDialog(Shell shell, String title) {
		super(shell);
		setText(title);
	}
	public Object open () {
		Shell parent = getParent();
		shell = new Shell(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shell.setText(getText());
		shell.setLayout(new FillLayout());
		shell.setBounds(0,0,400,120);
		// Your code goes here (widget creation, set result, etc).
		
		initGraphics();
		shell.pack();

		Rectangle r = parent.getBounds();
		Rectangle z = shell.getBounds();
		if (z.width < 400) z.width = 400;
		if (z.height < 120) z.height = 120;

		shell.setBounds( r.x + (r.width/2) - (z.width/2),
						 r.y + (r.height/2) - (z.height/2),
						 z.width,
						 z.height
						 );
		
		shell.open();
		Display display = parent.getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) display.sleep();
		}
		
		if (ok) {
			return new Long(getDate());
		} else {
			return null;	
		}
	}
	
	public void setDate(long t) {
		thedate = t;
		try {
			date_panel.setDate(t);
		} catch (Throwable e) {
		}
	}
	
	public long getDate() {
		return date_panel.getDate();
	}
	
	private void initGraphics() {
		main_panel = new Composite(shell,0);
		
		GridLayout glayout = new GridLayout();
		glayout.numColumns = 1;
		main_panel.setLayout(glayout);

		date_panel = new DateSpinner(main_panel,0);
		date_panel.setLayoutData(GData.getGridData(true,true,-1,-1,1,1,GridData.FILL,GridData.FILL));

		button_panel = new Composite(main_panel,0);
		button_panel.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.END));

		glayout = new GridLayout();
		glayout.numColumns = 2;
		button_panel.setLayout(glayout);

		ok_button = new Button(button_panel,0);
		ok_button.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.END));
		ok_button.setText(EditorPlugin.getString("OK"));

		cancel_button = new Button(button_panel,0);
		cancel_button.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.END));
		cancel_button.setText(EditorPlugin.getString("CANCEL"));
	        
        ButtonListener blist = new ButtonListener();
        
        ok_button.addSelectionListener(blist);
        cancel_button.addSelectionListener(blist);
    
    
    	setDate(thedate);
	}
	
	
	class ButtonListener implements SelectionListener {
        
        public void widgetDefaultSelected(SelectionEvent e) {
        	widgetSelected(e);
        }
        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == cancel_button) {
                ok = false;
                shell.dispose();
                
            } else if (e.getSource() == ok_button) {
                ok = true;
                shell.dispose();
                
            }//end if
        }//end method
        
    }//end class

}