/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.Calendar;
import java.util.Date;

public class TimeZoomSliderTick extends ZoomSliderTick
{
    int hrs, mins, secs;
    
    String hrs$, mins$, secs$;
    
	public TimeZoomSliderTick(ZoomSlider slider, double d)
	{
		this.slider = slider;
        
        value = d;
        
        calculateComponents();
        
        if (((TimeZoomSlider)slider).isWallTime())
        {
            representation = hrs$ + ":" + mins$ + ":" + secs$;
        }
        else
        {
            representation = "";
            
            if (hrs != 0)
            {
                representation += hrs$ + ":";
            }
            if (mins != 0 || hrs != 0)
            {
                representation += mins$ + ":";
            }
            
            representation += secs$;
        }    
        
        pixel = (int)slider.value2Pixel(value);
        
        textVisible = isTextVisible();
    }
	
    public void calculateComponents()
    {
        long millis = (long)value;
        
        if (!((TimeZoomSlider)slider).isWallTime())
        {
            millis = (long)value - slider.rawOffset;
        }    
        
        ((TimeZoomSlider)slider).calendar.setTime(new Date(millis));
        
        hrs = ((TimeZoomSlider)slider).calendar.get(Calendar.HOUR_OF_DAY);
        hrs$ = String.valueOf(hrs);
        if (hrs$.length() == 1) hrs$ = "0" + hrs$;

        mins = ((TimeZoomSlider)slider).calendar.get(Calendar.MINUTE);
        mins$ = String.valueOf(mins);
        if (mins$.length() == 1) mins$ = "0" + mins$;

        secs = ((TimeZoomSlider)slider).calendar.get(Calendar.SECOND);
        secs$ = String.valueOf(secs);
        if (secs$.length() == 1) secs$ = "0" + secs$;
    }    

    protected boolean isTextVisible()
    {
        int inc = (int)((long)(slider.getIncrement())/1000);
        
        switch (inc)
        {
            case 1:     return (secs%5 == 0);
                    
            case 2:     return (secs%10 == 0);
        
            case 5:     return (secs%15 == 0);
            
            case 10:    return (secs%30 == 0);

            case 20:    return (secs%60 == 0);
            
            case 30:    return (secs%60 == 0 && mins%2 == 0);
            
            case 60:    return (mins%5 == 0);
            
            case 120:   return (mins%10 == 0);

            case 300:   return (mins%20 == 0);

            case 600:   return (mins%60 == 0);
            
            case 1200:  return (mins%60 == 0 && hrs%2 == 0);

            case 1800:  return (mins%60 == 0 && hrs%2 == 0);
            
            case 3600:  return (hrs%3 == 0);

            case 7200:  return (hrs%6 == 0);
            
            default:    return true;
        }    
    }
}
