/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IgnoredXMLFragmentLoader.java,v 1.6 2005/02/16 22:21:22 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;


/**
 * @author slavescu
 */
public class IgnoredXMLFragmentLoader implements XMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    protected HierarchyContext context;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
    	// do nothing
    }

    public void addCharacters(char[] data, int offset, int length) {
    	// do nothing
    }

    public void addYourselfInContext() {
    	// do nothing
    }

    public void cleanUp() {
        context = null;
    }

    public void endChild(String name) {
    	// do nothing
    }

    public void initialize(HierarchyContext context, String elementName) {
        this.context = context;
    }

    public void startChild(String name) {
    	// do nothing
    }
}
