/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLfilterLoader.java,v 1.8 2005/02/16 22:21:22 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;


public class XMLfilterLoader extends IgnoredXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    protected String genericPattern;
    protected String mode;
    protected String pattern;
    protected String methodPattern;
    protected String methodMode;
    protected String methodGenericPattern;

    //~ Methods ------------------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
     */
    public void addAttribute(String name, String value) {
        if (name.equals("genericPattern")) {
            genericPattern = value;
        } else if (name.equals("mode")) {
            mode = value;
        } else if (name.equals("pattern")) {
            pattern = value;
        } else if (name.equals("methodPattern")) {
        	methodPattern = value;
        } else if (name.equals("methodMode")) {
        	methodMode = value;
        } else if (name.equals("methodGenericPattern")) {
        	methodGenericPattern = value;
        }
    }

    public void addYourselfInContext() {
        TRCAgent agent = context.getAgent();

        if (agent == null) {
            LoadersUtils.createAgent(context);
        }


        TRCAgentProxy agentProxy = context.getAgentProxy();

		if (agentProxy == null) {
			agentProxy = agent.getAgentProxy();
		}

        TRCConfiguration config = null;
        Object[] configList = agentProxy.getConfigurations().toArray();

        for (int idx = 0; idx < configList.length; idx++) {
            TRCConfiguration c = (TRCConfiguration) configList[idx];

            if ((c.getName() != null) && c.getName().equals("__JVMPI__")) {
                config = c;

                break;
            }
        }

        if (config == null) {
            config = HierarchyFactory.eINSTANCE.createTRCConfiguration();
            config.setName("__JVMPI__");
            config.setActive(true);
            config.setAgentProxy(agentProxy);
        }

        TRCFilter filter = HierarchyFactory.eINSTANCE.createTRCFilter();

        if(methodPattern==null || methodPattern.trim().length()==0)
        {
            filter.setOperation("*");
        }
        else
        {
            if(methodGenericPattern!=null && methodGenericPattern.trim().length()>0)
            	filter.setOperation((methodGenericPattern.equals("PREFIX") ? "*":"")+methodPattern+(methodGenericPattern.equals("SUFFIX") ? "*":""));
            else
            	filter.setOperation("*");
        }
        
        if(genericPattern!=null && genericPattern.trim().length()>0)
        	filter.setPattern((genericPattern.equals("PREFIX") ? "*":"")+pattern+(genericPattern.equals("SUFFIX") ? "*":""));
        else
        	filter.setPattern("*");
        
        if(methodMode!=null && methodMode.trim().length()>0)
        	filter.setMode(methodMode);
        if(mode!=null && mode.trim().length()>0)
        	filter.setType(mode);
        	
        filter.setActive(Boolean.TRUE);
        filter.setConfiguration(config);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(java.lang.String)
     */
    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        pattern = null;
        genericPattern = null;
        mode = null;
        methodPattern=null;
        methodMode=null;
        methodGenericPattern=null;
    }
}
