/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLprocessCreateLoader.java,v 1.18 2005/04/18 21:02:33 slavescu Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.loaders.hierarchy;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
public class XMLprocessCreateLoader extends IgnoredXMLFragmentLoader {
	//~ Instance fields
	// ----------------------------------------------------------------------------
	protected String application_executable;
	protected String pName;
	protected String nodeIdRef;
	protected String processId;
	protected TRCProcessProxy process;
	protected int pid;
	//~ Methods
	// ------------------------------------------------------------------------------------
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.loader.XMLFragmentLoader#addAttribute(java.lang.String,
	 *      java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		if (name.equals("processId")) {
			processId = value;
		} else if (name.equals("nodeIdRef")) {
			nodeIdRef = value;
		} else if (name.equals("name")) {
			pName = value;
		} else if (name.equals("pid")) {
			pid = Integer.valueOf(value).intValue();
		} else if (name.equals("application_executable")) {
			application_executable = value;
		}
	}
	public void addYourselfInContext() {
		TRCMonitor monitor = context.getMonitor();
		if (monitor == null) {
			return;
		}
		TRCNode node = context.getNode();
		/* If we don't have a node association, find one based upon our monitor */
		if (node == null) {
			EList list = monitor.getNodes();
			Iterator i = list.iterator();
			while (i.hasNext()) {
				node = (TRCNode) i.next();
				if (!node.eIsProxy()) {
					String id = node.getRuntimeId();
					if ((id != null) && id.equals(nodeIdRef)) {
						context.setNode(node);
						break;
					}
				}
			}
		} else {
			if ((node.getRuntimeId() != null) && !node.getRuntimeId().equals(nodeIdRef)) {
				EList list = monitor.getNodes();
				Iterator i = list.iterator();
				while (i.hasNext()) {
					node = (TRCNode) i.next();
					if (!node.eIsProxy()) {
						String id = node.getRuntimeId();
						if ((id != null) && id.equals(nodeIdRef)) {
							context.setNode(node);
							break;
						}
					}
				}
			}
		}
		//node.setRuntimeId(nodeIdRef);
		process = LoadersUtils.locateProcessFromNode(node, pid, processId);
		if (process == null) {
			//            EList procExt = new BasicEList();
			String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
			Resource procDoc = null;
			if (monitorFolder != null) {
				//create the process
				StringBuffer buffer = (new StringBuffer(monitor.getName())).append("_").append(node.getName()).append("_").append(pid).append("_").append(processId);
				String pName = buffer.toString();
				pName = StringUtil.change(pName, " ", "");
				pName = StringUtil.change(pName, "\"", "");
				String pFileName = monitorFolder + pName;
				procDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(pFileName + ".trcpxmi")).createResource(SaveUtil.createURI(pFileName + ".trcpxmi"));
				procDoc.setModified(true);
				HierarchyResourceSetImpl.getInstance().getResources().add(procDoc);
				//*** adding support for multiple files
				//                SaveUtil.addDocument(procDoc);
			}
			process = HierarchyFactory.eINSTANCE.createTRCProcessProxy();
			process.setNode(node);
			if (procDoc != null) {
				procDoc.getContents().add(process);
			}
		}
		process.setPid(pid);
		if (processId != null) {
			process.setRuntimeId(processId);
		} else if (process.getRuntimeId() == null) {
			process.setRuntimeId("0");
		}
		
		setProcessArguments(process);
		
		if(process.getName()==null || process.getName().equals("unknown"))
			process.setName(pName);
		
		context.setProcessProxy(process);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext,
	 *      java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		processId = "0";
		nodeIdRef = "0";
		application_executable = "";
		pName = "unknown";
		process = null;
		pid = -1;
	}
	private void setProcessArguments(TRCProcessProxy process) {
		if (application_executable == null) {
			return;
		}
		String params = "";
		String vmparam = "";
		String classpath = "";
		int java_index = application_executable.indexOf("java.exe");
		if (java_index < 0) {
			java_index = application_executable.indexOf("javaw.exe");
			if (java_index > 0) {
				java_index += "javaw.exe".length();
			}
		} else {
			java_index += "java.exe".length();
		}
		if (java_index > 0) {
			String exeName = application_executable.substring(java_index).trim();
			//            if (!exeName.startsWith("-X")) { //log agents
			//                exeName = "-X " + exeName;
			//            }
			int idx = exeName.indexOf(" ");
			if (!exeName.startsWith("-")) {
				if ((idx != -1) && (idx < (exeName.length() + 1))) {
					exeName = exeName.substring(idx + 1);
				}
			}
			while (exeName.startsWith("-")) {
				if (exeName.startsWith("-cp") || exeName.startsWith("-classpath")) {
					idx = exeName.indexOf(" ");
					if (idx != -1) {
						exeName = exeName.substring(idx).trim();
					}
					idx = exeName.indexOf(" ");
					if (idx != -1) {
						classpath = exeName.substring(0, idx);
						exeName = exeName.substring(idx).trim();
					}
				} else {
					idx = exeName.indexOf(" ");
					if (idx != -1) {
						vmparam += (exeName.substring(0, idx) + " ");
						exeName = exeName.substring(idx).trim();
					}
				}
			}
			idx = exeName.indexOf(" ");
			if (idx != -1) {
				if (pName.equals("unknown")) {
					pName = exeName.substring(0, idx);
				}
				params = exeName.substring(idx).trim();
			} else {
				if (pName.equals("unknown") && exeName.trim().length() > 0)
					pName = exeName;
			}
		}
		process.setClasspath(classpath);
		process.setParameters(params);
		process.setVmArguments(vmparam);
//		process.setLaunchMode(1);
	}
}