/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentProxyContext.java,v 1.3 2005/02/16 22:21:22 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;


public class AgentProxyContext {
    private TRCAgentProxy agentProxy;
    private TRCCollectionMode collectionMode = TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;
    private boolean loadToModel = true;
    private Object agentListener;
	private Object agentInstance;
	private XMLLoader dataProcessor;
    

	/**
	 * 
	 */
	public AgentProxyContext() {
		super();
	}

    /**
     * Sets the agentProxy.
     * @param agentProxy The agentProxy to set
     */
    public void setAgentProxy(TRCAgentProxy agentProxy) {
        this.agentProxy = agentProxy;
    }

    /**
     * @return TRCAgentProxy
     */
    public TRCAgentProxy getAgentProxy() {
        return agentProxy;
    }

    /**
     * Sets the collectionMode.
     * @param collectionMode The collectionMode to set
     */
    public void setCollectionMode(TRCCollectionMode collectionMode) {
        this.collectionMode = collectionMode;
    }

    /**
     * @return TRCCollectionMode
     */
    public TRCCollectionMode getCollectionMode() {
        return collectionMode;
    }

    /**
     * Sets the loadToModel.
     * @param loadToModel The loadToModel to set
     */
    public void setLoadToModel(boolean loadToModel) {
        this.loadToModel = loadToModel;
    }

    /**
     * @return boolean
     */
    public boolean isLoadToModel() {
        return loadToModel;
    }

	/**
	 * @return
	 */
	public Object getAgentListener() {
		return agentListener;
	}

	/**
	 * @return
	 */
	public XMLLoader getDataProcessor() {
		return dataProcessor;
	}

	/**
	 * @param object
	 */
	public void setAgentListener(Object object) {
		agentListener = object;
	}

	/**
	 * @param loader
	 */
	public void setDataProcessor(XMLLoader loader) {
		dataProcessor = loader;
	}

	/**
	 * @return
	 */
	public Object getAgentInstance() {
		return agentInstance;
	}

	/**
	 * @param object
	 */
	public void setAgentInstance(Object object) {
		agentInstance = object;
	}

}
