/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HierarchyContext.java,v 1.11 2005/03/29 15:12:03 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.internal.ImportFilterEngine;


public class HierarchyContext extends AgentProxyContext{
    //~ Instance fields ----------------------------------------------------------------------------

    private List globalForwardReferences;
	private String contextURI;
    private TRCAgent agent;
    private TRCMonitor monitor;
    private TRCNode node;
    private TRCProcessProxy processProxy;
    private Map customData;
	private SimpleSearchQuery importFilter;
	private ImportFilterEngine filterEngine;
	/**
	 *
	 */

	public HierarchyContext() {
		super();
	}

    //~ Methods ------------------------------------------------------------------------------------

    /**
     * Sets the agent.
     * @param agent The agent to set
     */
    public void setAgent(TRCAgent agent) {
        this.agent = agent;
    }

    /**
     * @return TRCAgent
     */
    public TRCAgent getAgent() {
        return agent;
    }

    /**
     * Sets the globalForwardReferences.
     * @param globalForwardReferences The globalForwardReferences to set
     */
    public void setGlobalForwardReferences(List globalForwardReferences) {
        this.globalForwardReferences = globalForwardReferences;
    }

    /**
     * @return List
     */
    public List getGlobalForwardReferences() {
    	if(globalForwardReferences==null)
			globalForwardReferences = new ArrayList();
        return globalForwardReferences;
    }

    /**
     * Sets the monitor.
     * @param monitor The monitor to set
     */
    public void setMonitor(TRCMonitor monitor) {
        this.monitor = monitor;
    }

    /**
     * @return TRCMonitor
     */
    public TRCMonitor getMonitor() {
        return monitor;
    }

    /**
     * Sets the node.
     * @param node The node to set
     */
    public void setNode(TRCNode node) {
        this.node = node;
    }

    /**
     * @return TRCNode
     */
    public TRCNode getNode() {
        return node;
    }

    /**
     * Sets the processProxy.
     * @param processProxy The processProxy to set
     */
    public void setProcessProxy(TRCProcessProxy processProxy) {
        this.processProxy = processProxy;
    }

    /**
     * @return TRCProcessProxy
     */
    public TRCProcessProxy getProcessProxy() {
        return processProxy;
    }
	/**
	 * @return
	 */
	public String getContextURI() {
		return contextURI;
	}

	/**
	 * @param string
	 */
	public void setContextURI(String string) {
		contextURI = string;
	}

	/**
	 * Map for storing custom data, each loader can add it's own key/value pairs.
	 * @return
	 */
	public Map getCustomData()
	{
		if(customData==null)
			customData = new HashMap();
		return customData;
	}

	/**
	 * @param map
	 */
	public void setCustomData(Map map)
	{
		customData = map;
	}

	/**
	 * @return
	 */
	public boolean isFilterOn() {
		return importFilter!=null;
	}

	/**
	 * @return
	 */
	public ImportFilterEngine getFilterEngine() {
		if(filterEngine==null)
		{
			filterEngine = new ImportFilterEngine(importFilter,null);
		}
		return filterEngine;
	}
	
	/**
	 * @param importFilter The importFilter to set.
	 */
	public void setImportFilter(SimpleSearchQuery importFilter) {
		this.importFilter = importFilter;
	}

}
