/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ResourceExtensions.java,v 1.3 2005/02/16 22:21:22 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.HashMap;

/**
 * @author slavescu
 */
public class ResourceExtensions extends HashMap {
    //~ Static fields/initializers -----------------------------------------------------------------

    private static ResourceExtensions instance;

    //~ Constructors -------------------------------------------------------------------------------

    /**
     *
     */
    private ResourceExtensions() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    /**
     *
     */
    public static ResourceExtensions getInstance() {
        if (instance == null) {
            instance = new ResourceExtensions();
            new ResourceRegistryReader().readRegistry();
        }

        return instance;
    }
}


/**
 * A plugin extension reader that populates the
 * loaders registry.
 * Clients are not expected to use this class directly.
 */
class ResourceRegistryReader extends RegistryReader {
    //~ Static fields/initializers -----------------------------------------------------------------

    static final String TAG_RESOURCE_LOADER = "resourceLoader";
    static final String ATT_FILE_EXTENSION = "fileExtension";
    static final String ATT_CLASS = "class";

    //~ Constructors -------------------------------------------------------------------------------

    public ResourceRegistryReader() {
        super(RegistryReader.RESOURCE_LOADER_PPID);
    }

    //~ Methods ------------------------------------------------------------------------------------

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_RESOURCE_LOADER)) {
            String fileExtension = element.getAttribute(ATT_FILE_EXTENSION);

            if (fileExtension == null) {
                logMissingAttribute(element, ATT_FILE_EXTENSION);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                logMissingAttribute(element, ATT_CLASS);
            } else {
                if (ResourceExtensions.getInstance().containsKey(fileExtension)) {
                    logError(element, "A resource loader for this element already exists, this loader will be ignored.");
                } else {
                    try {
                        IHyadesPluginClassDescriptor classDescriptor = createPluginClassDescriptor(element, ATT_CLASS);

                        ResourceExtensions.getInstance().put(fileExtension, (XMLResourceLoader) classDescriptor.createInstance());
                    } catch (Exception e) {
                        logError(element, e.getLocalizedMessage());
                    }

                    return true;
                }
            }
        }

        return false;
    }
}
