/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCAgentImpl.java,v 1.22 2005/03/16 19:35:58 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent;
import org.eclipse.hyades.models.hierarchy.AbstractTRCDescription;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;
import org.eclipse.hyades.models.hierarchy.AbstractTRCView;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Agent</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getRuntimeId <em>Runtime Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getStopTime <em>Stop Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getCollectionMode <em>Collection Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getDefaultEvents <em>Default Events</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getView <em>View</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getDescriptor <em>Descriptor</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getAgentProxy <em>Agent Proxy</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl#getUnresolvedCorrelations <em>Unresolved Correlations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCAgentImpl extends EObjectImpl  implements TRCAgent {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = "_unknown";

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getRuntimeId() <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimeId()
	 * @generated
	 * @ordered
	 */
	protected static final String RUNTIME_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRuntimeId() <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimeId()
	 * @generated
	 * @ordered
	 */
	protected String runtimeId = RUNTIME_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected static final double START_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected double startTime = START_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected static final double STOP_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected double stopTime = STOP_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectionMode() <em>Collection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectionMode()
	 * @generated
	 * @ordered
	 */
	protected static final TRCCollectionMode COLLECTION_MODE_EDEFAULT = TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;

	/**
	 * The cached value of the '{@link #getCollectionMode() <em>Collection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectionMode()
	 * @generated
	 * @ordered
	 */
	protected TRCCollectionMode collectionMode = COLLECTION_MODE_EDEFAULT;

	/**
	 * The default value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected String version = VERSION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDefaultEvents() <em>Default Events</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefaultEvents()
	 * @generated
	 * @ordered
	 */
	protected EList defaultEvents = null;

	/**
	 * The cached value of the '{@link #getView() <em>View</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getView()
	 * @generated
	 * @ordered
	 */
	protected AbstractTRCView view = null;

	/**
	 * The cached value of the '{@link #getDescriptor() <em>Descriptor</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescriptor()
	 * @generated
	 * @ordered
	 */
	protected EList descriptor = null;

	/**
	 * The cached value of the '{@link #getProcess() <em>Process</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcess()
	 * @generated
	 * @ordered
	 */
	protected AbstractTRCProcess process = null;

	/**
	 * The cached value of the '{@link #getAgentProxy() <em>Agent Proxy</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAgentProxy()
	 * @generated
	 * @ordered
	 */
	protected TRCAgentProxy agentProxy = null;

	/**
	 * The cached value of the '{@link #getUnresolvedCorrelations() <em>Unresolved Correlations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnresolvedCorrelations()
	 * @generated
	 * @ordered
	 */
	protected EList unresolvedCorrelations = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCAgentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return HierarchyPackage.eINSTANCE.getTRCAgent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getRuntimeId() {
		return runtimeId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRuntimeId(String newRuntimeId) {
		String oldRuntimeId = runtimeId;
		runtimeId = newRuntimeId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__RUNTIME_ID, oldRuntimeId, runtimeId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStartTime() {
		return startTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartTime(double newStartTime) {
		double oldStartTime = startTime;
		startTime = newStartTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__START_TIME, oldStartTime, startTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStopTime() {
		return stopTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStopTime(double newStopTime) {
		double oldStopTime = stopTime;
		stopTime = newStopTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__STOP_TIME, oldStopTime, stopTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCCollectionMode getCollectionMode() {
		return collectionMode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectionMode(TRCCollectionMode newCollectionMode) {
		TRCCollectionMode oldCollectionMode = collectionMode;
		collectionMode = newCollectionMode == null ? COLLECTION_MODE_EDEFAULT : newCollectionMode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__COLLECTION_MODE, oldCollectionMode, collectionMode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVersion(String newVersion) {
		String oldVersion = version;
		version = newVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__VERSION, oldVersion, version));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList getDefaultEvents()
	{
		if (defaultEvents == null) {
			defaultEvents = HyadesResourceExtensions.getInstance().createList(AbstractDefaultEvent.class, this, HierarchyPackage.TRC_AGENT__DEFAULT_EVENTS, HierarchyPackage.ABSTRACT_DEFAULT_EVENT__AGENT);
			if(defaultEvents==null)
				defaultEvents = new EObjectContainmentWithInverseEList(AbstractDefaultEvent.class, this, HierarchyPackage.TRC_AGENT__DEFAULT_EVENTS, HierarchyPackage.ABSTRACT_DEFAULT_EVENT__AGENT);
		}
		return defaultEvents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AbstractTRCView getView() {
		return view;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetView(AbstractTRCView newView, NotificationChain msgs) {
		AbstractTRCView oldView = view;
		view = newView;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__VIEW, oldView, newView);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setView(AbstractTRCView newView) {
		if (newView != view) {
			NotificationChain msgs = null;
			if (view != null)
				msgs = ((InternalEObject)view).eInverseRemove(this, HierarchyPackage.ABSTRACT_TRC_VIEW__AGENT, AbstractTRCView.class, msgs);
			if (newView != null)
				msgs = ((InternalEObject)newView).eInverseAdd(this, HierarchyPackage.ABSTRACT_TRC_VIEW__AGENT, AbstractTRCView.class, msgs);
			msgs = basicSetView(newView, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__VIEW, newView, newView));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDescriptor() {
		if (descriptor == null) {
			descriptor = new EObjectContainmentWithInverseEList(AbstractTRCDescription.class, this, HierarchyPackage.TRC_AGENT__DESCRIPTOR, HierarchyPackage.ABSTRACT_TRC_DESCRIPTION__AGENT);
		}
		return descriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AbstractTRCProcess getProcess() {
		return process;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProcess(AbstractTRCProcess newProcess, NotificationChain msgs) {
		AbstractTRCProcess oldProcess = process;
		process = newProcess;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__PROCESS, oldProcess, newProcess);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(AbstractTRCProcess newProcess) {
		if (newProcess != process) {
			NotificationChain msgs = null;
			if (process != null)
				msgs = ((InternalEObject)process).eInverseRemove(this, HierarchyPackage.ABSTRACT_TRC_PROCESS__AGENT, AbstractTRCProcess.class, msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, HierarchyPackage.ABSTRACT_TRC_PROCESS__AGENT, AbstractTRCProcess.class, msgs);
			msgs = basicSetProcess(newProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__PROCESS, newProcess, newProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAgentProxy getAgentProxy() {
		if (agentProxy != null && agentProxy.eIsProxy()) {
			TRCAgentProxy oldAgentProxy = agentProxy;
			agentProxy = (TRCAgentProxy)eResolveProxy((InternalEObject)agentProxy);
			if (agentProxy != oldAgentProxy) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.TRC_AGENT__AGENT_PROXY, oldAgentProxy, agentProxy));
			}
		}
		return agentProxy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAgentProxy basicGetAgentProxy() {
		return agentProxy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAgentProxy(TRCAgentProxy newAgentProxy, NotificationChain msgs) {
		TRCAgentProxy oldAgentProxy = agentProxy;
		agentProxy = newAgentProxy;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__AGENT_PROXY, oldAgentProxy, newAgentProxy);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAgentProxy(TRCAgentProxy newAgentProxy) {
		if (newAgentProxy != agentProxy) {
			NotificationChain msgs = null;
			if (agentProxy != null)
				msgs = ((InternalEObject)agentProxy).eInverseRemove(this, HierarchyPackage.TRC_AGENT_PROXY__AGENT, TRCAgentProxy.class, msgs);
			if (newAgentProxy != null)
				msgs = ((InternalEObject)newAgentProxy).eInverseAdd(this, HierarchyPackage.TRC_AGENT_PROXY__AGENT, TRCAgentProxy.class, msgs);
			msgs = basicSetAgentProxy(newAgentProxy, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT__AGENT_PROXY, newAgentProxy, newAgentProxy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getUnresolvedCorrelations() {
		if (unresolvedCorrelations == null) {
			unresolvedCorrelations = new EObjectContainmentWithInverseEList(UnresolvedCorrelation.class, this, HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS, HierarchyPackage.UNRESOLVED_CORRELATION__AGENT);
		}
		return unresolvedCorrelations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_AGENT__DEFAULT_EVENTS:
					return ((InternalEList)getDefaultEvents()).basicAdd(otherEnd, msgs);
				case HierarchyPackage.TRC_AGENT__VIEW:
					if (view != null)
						msgs = ((InternalEObject)view).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - HierarchyPackage.TRC_AGENT__VIEW, null, msgs);
					return basicSetView((AbstractTRCView)otherEnd, msgs);
				case HierarchyPackage.TRC_AGENT__DESCRIPTOR:
					return ((InternalEList)getDescriptor()).basicAdd(otherEnd, msgs);
				case HierarchyPackage.TRC_AGENT__PROCESS:
					if (process != null)
						msgs = ((InternalEObject)process).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - HierarchyPackage.TRC_AGENT__PROCESS, null, msgs);
					return basicSetProcess((AbstractTRCProcess)otherEnd, msgs);
				case HierarchyPackage.TRC_AGENT__AGENT_PROXY:
					if (agentProxy != null)
						msgs = ((InternalEObject)agentProxy).eInverseRemove(this, HierarchyPackage.TRC_AGENT_PROXY__AGENT, TRCAgentProxy.class, msgs);
					return basicSetAgentProxy((TRCAgentProxy)otherEnd, msgs);
				case HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS:
					return ((InternalEList)getUnresolvedCorrelations()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_AGENT__DEFAULT_EVENTS:
					return ((InternalEList)getDefaultEvents()).basicRemove(otherEnd, msgs);
				case HierarchyPackage.TRC_AGENT__VIEW:
					return basicSetView(null, msgs);
				case HierarchyPackage.TRC_AGENT__DESCRIPTOR:
					return ((InternalEList)getDescriptor()).basicRemove(otherEnd, msgs);
				case HierarchyPackage.TRC_AGENT__PROCESS:
					return basicSetProcess(null, msgs);
				case HierarchyPackage.TRC_AGENT__AGENT_PROXY:
					return basicSetAgentProxy(null, msgs);
				case HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS:
					return ((InternalEList)getUnresolvedCorrelations()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_AGENT__NAME:
				return getName();
			case HierarchyPackage.TRC_AGENT__TYPE:
				return getType();
			case HierarchyPackage.TRC_AGENT__RUNTIME_ID:
				return getRuntimeId();
			case HierarchyPackage.TRC_AGENT__START_TIME:
				return new Double(getStartTime());
			case HierarchyPackage.TRC_AGENT__STOP_TIME:
				return new Double(getStopTime());
			case HierarchyPackage.TRC_AGENT__COLLECTION_MODE:
				return getCollectionMode();
			case HierarchyPackage.TRC_AGENT__VERSION:
				return getVersion();
			case HierarchyPackage.TRC_AGENT__DEFAULT_EVENTS:
				return getDefaultEvents();
			case HierarchyPackage.TRC_AGENT__VIEW:
				return getView();
			case HierarchyPackage.TRC_AGENT__DESCRIPTOR:
				return getDescriptor();
			case HierarchyPackage.TRC_AGENT__PROCESS:
				return getProcess();
			case HierarchyPackage.TRC_AGENT__AGENT_PROXY:
				if (resolve) return getAgentProxy();
				return basicGetAgentProxy();
			case HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS:
				return getUnresolvedCorrelations();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_AGENT__NAME:
				setName((String)newValue);
				return;
			case HierarchyPackage.TRC_AGENT__TYPE:
				setType((String)newValue);
				return;
			case HierarchyPackage.TRC_AGENT__RUNTIME_ID:
				setRuntimeId((String)newValue);
				return;
			case HierarchyPackage.TRC_AGENT__START_TIME:
				setStartTime(((Double)newValue).doubleValue());
				return;
			case HierarchyPackage.TRC_AGENT__STOP_TIME:
				setStopTime(((Double)newValue).doubleValue());
				return;
			case HierarchyPackage.TRC_AGENT__COLLECTION_MODE:
				setCollectionMode((TRCCollectionMode)newValue);
				return;
			case HierarchyPackage.TRC_AGENT__VERSION:
				setVersion((String)newValue);
				return;
			case HierarchyPackage.TRC_AGENT__DEFAULT_EVENTS:
				getDefaultEvents().clear();
				getDefaultEvents().addAll((Collection)newValue);
				return;
			case HierarchyPackage.TRC_AGENT__VIEW:
				setView((AbstractTRCView)newValue);
				return;
			case HierarchyPackage.TRC_AGENT__DESCRIPTOR:
				getDescriptor().clear();
				getDescriptor().addAll((Collection)newValue);
				return;
			case HierarchyPackage.TRC_AGENT__PROCESS:
				setProcess((AbstractTRCProcess)newValue);
				return;
			case HierarchyPackage.TRC_AGENT__AGENT_PROXY:
				setAgentProxy((TRCAgentProxy)newValue);
				return;
			case HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS:
				getUnresolvedCorrelations().clear();
				getUnresolvedCorrelations().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_AGENT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT__RUNTIME_ID:
				setRuntimeId(RUNTIME_ID_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT__START_TIME:
				setStartTime(START_TIME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT__STOP_TIME:
				setStopTime(STOP_TIME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT__COLLECTION_MODE:
				setCollectionMode(COLLECTION_MODE_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT__VERSION:
				setVersion(VERSION_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT__DEFAULT_EVENTS:
				getDefaultEvents().clear();
				return;
			case HierarchyPackage.TRC_AGENT__VIEW:
				setView((AbstractTRCView)null);
				return;
			case HierarchyPackage.TRC_AGENT__DESCRIPTOR:
				getDescriptor().clear();
				return;
			case HierarchyPackage.TRC_AGENT__PROCESS:
				setProcess((AbstractTRCProcess)null);
				return;
			case HierarchyPackage.TRC_AGENT__AGENT_PROXY:
				setAgentProxy((TRCAgentProxy)null);
				return;
			case HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS:
				getUnresolvedCorrelations().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_AGENT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case HierarchyPackage.TRC_AGENT__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case HierarchyPackage.TRC_AGENT__RUNTIME_ID:
				return RUNTIME_ID_EDEFAULT == null ? runtimeId != null : !RUNTIME_ID_EDEFAULT.equals(runtimeId);
			case HierarchyPackage.TRC_AGENT__START_TIME:
				return startTime != START_TIME_EDEFAULT;
			case HierarchyPackage.TRC_AGENT__STOP_TIME:
				return stopTime != STOP_TIME_EDEFAULT;
			case HierarchyPackage.TRC_AGENT__COLLECTION_MODE:
				return collectionMode != COLLECTION_MODE_EDEFAULT;
			case HierarchyPackage.TRC_AGENT__VERSION:
				return VERSION_EDEFAULT == null ? version != null : !VERSION_EDEFAULT.equals(version);
			case HierarchyPackage.TRC_AGENT__DEFAULT_EVENTS:
				return defaultEvents != null && !defaultEvents.isEmpty();
			case HierarchyPackage.TRC_AGENT__VIEW:
				return view != null;
			case HierarchyPackage.TRC_AGENT__DESCRIPTOR:
				return descriptor != null && !descriptor.isEmpty();
			case HierarchyPackage.TRC_AGENT__PROCESS:
				return process != null;
			case HierarchyPackage.TRC_AGENT__AGENT_PROXY:
				return agentProxy != null;
			case HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS:
				return unresolvedCorrelations != null && !unresolvedCorrelations.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", type: ");
		result.append(type);
		result.append(", runtimeId: ");
		result.append(runtimeId);
		result.append(", startTime: ");
		result.append(startTime);
		result.append(", stopTime: ");
		result.append(stopTime);
		result.append(", collectionMode: ");
		result.append(collectionMode);
		result.append(", version: ");
		result.append(version);
		result.append(')');
		return result.toString();
	}

} //TRCAgentImpl
