/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CompoundIterator.java,v 1.1 2005/03/16 17:54:52 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
/**
 * @author Marius Slavescu (slavescu@ca.ibm.com)
 * @since 3.3
 *  
 */
public class CompoundIterator implements Iterator {
	int currentPos;
	List elementProviders = new FastList();
	public void addIterator(Iterator iterator) {
		elementProviders.add(iterator);
	}
	public void addObject(Object object) {
		elementProviders.add(object);
	}
	public void clear() {
		currentPos = 0;
		elementProviders.clear();
	}
	public boolean hasNext() {
		if (elementProviders.size() > currentPos) {
			if (elementProviders.get(currentPos) instanceof Iterator) {
				return ((Iterator) elementProviders.get(currentPos)).hasNext();
			} else
				return true;
		}
		return false;
	}
	public Object next() {
		if (elementProviders.size() > currentPos) {
			if (elementProviders.get(currentPos) instanceof Iterator) {
				Object res = ((Iterator) elementProviders.get(currentPos)).next();
				if (!((Iterator) elementProviders.get(currentPos)).hasNext())
					currentPos++;
				return res;
			} else {
				return elementProviders.get(currentPos++);
			}
		} else
			throw new NoSuchElementException();
	}
	public void remove() {
		if (elementProviders.size() > currentPos) {
			if (elementProviders.get(currentPos) instanceof Iterator) {
				((Iterator) elementProviders.get(currentPos)).remove();
				if (!((Iterator) elementProviders.get(currentPos)).hasNext())
					currentPos++;
			} else {
				elementProviders.remove(currentPos - 1);
			}
		} else
			throw new NoSuchElementException();
	}
}