/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContainmentTraverser.java,v 1.9 2005/03/17 20:01:50 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
/**
 * @author slavescu
 */
public class ContainmentTraverser extends EObjectsTraverser {
	public static final class ChildrenIteratorPool {
		private int currentEntryIndex = -1;
		private ArrayList iterators = new ArrayList(20);
		public ChildrenIteratorPool() {
			super();
		}
		public CompoundIterator alloc() {
			CompoundIterator iterator;
			if (iterators.size() == (currentEntryIndex + 1)) {
				iterator = new CompoundIterator();
				iterators.add(iterator);
				currentEntryIndex++;
			} else {
				currentEntryIndex++;
				iterator = (CompoundIterator) iterators.get(currentEntryIndex);
			}
			return iterator;
		}
		public void release(CompoundIterator children) {
			children.clear();
			currentEntryIndex--;
		}
	}
	public static final class ChildrenListPool {
		private int currentEntryIndex = -1;
		private ArrayList lists = new ArrayList(20);
		public ChildrenListPool() {
			super();
		}
		public List alloc() {
			List list;
			if (lists.size() == (currentEntryIndex + 1)) {
				list = new FastList();
				lists.add(list);
				currentEntryIndex++;
			} else {
				currentEntryIndex++;
				list = (List) lists.get(currentEntryIndex);
			}
			return list;
		}
		public void release(List children) {
			children.clear();
			currentEntryIndex--;
		}
	}
	private ChildrenIteratorPool childrenIteratorPool;
	private ChildrenListPool childrenPool;
	private boolean resolve;
	public ContainmentTraverser(Collection contents) {
		super(contents);
		resolve = true;
		childrenPool = new ChildrenListPool();
		childrenIteratorPool = new ChildrenIteratorPool();
	}
	public ContainmentTraverser(Collection contents, boolean resolve) {
		super(contents);
		this.resolve = resolve;
		childrenPool = new ChildrenListPool();
		childrenIteratorPool = new ChildrenIteratorPool();
	}
	protected EObject getElement(EObject traversedElement) {
		return traversedElement;
	}
	protected Iterator getIterator(EList result) {
		if (resolve)
			return result.iterator();
		else
			return ((InternalEList) result).basicIterator();
	}
	/**
	 * Returns true if the feature needs to be navigated
	 */
	protected boolean isRequiredFeature(EStructuralFeature sf) {
		return true;
	}
	private void populateChildrenList(EObject parent, List children) {
		List features = parent.eClass().getEAllContainments();
		for (int i = features.size() - 1; i >= 0; i--) {
			EStructuralFeature sf = (EStructuralFeature) features.get(i);
			if (!isRequiredFeature(sf))
				continue;
			if (parent.eIsSet(sf)) {
				Object result = parent.eGet(sf, resolve);
				if (result instanceof EList) {
					for (Iterator iter2 = getIterator((EList) result); iter2.hasNext();) {
						EObject element = (EObject) iter2.next();
						if (element != null)
							children.add(element);
					}
				} else if (result != null)
					children.add(result);
			}
		}
	}
	private void populateChildrenIterator(EObject parent, CompoundIterator childrenIterator) {
		List features = parent.eClass().getEAllContainments();
		for (int i = features.size() - 1; i >= 0; i--) {
			EStructuralFeature sf = (EStructuralFeature) features.get(i);
			if (!isRequiredFeature(sf))
				continue;
			if (parent.eIsSet(sf)) {
				Object result = parent.eGet(sf, resolve);
				if (result instanceof EList) {
					childrenIterator.addIterator(getIterator((EList) result));
				} else if (result != null)
					childrenIterator.addObject(result);
			}
		}
	}
	protected boolean traverseEObject(EObject object) {
		return traverseEObjectChildrenIterator(object);
	}
	protected boolean traverseEObjectChildrenIterator(EObject object) {
		CompoundIterator childrenIterator = childrenIteratorPool.alloc();
		populateChildrenIterator(object, childrenIterator);
		boolean res = traverse(childrenIterator);
		childrenIteratorPool.release(childrenIterator);
		return res;
	}
	protected boolean traverseEObjectChildrenList(EObject object) {
		List children = childrenPool.alloc();
		populateChildrenList(object, children);
		boolean res = traverse(children);
		childrenPool.release(children);
		return res;
	}
}