/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HierarchyXMIResourceImpl.java,v 1.19 2005/06/02 22:31:44 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.ResourceExtensions;
import org.eclipse.hyades.loaders.util.XMLResourceLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;

public class HierarchyXMIResourceImpl
	extends XMIResourceImpl
	implements XMIResource, IHyadesExtendedResource{
	//~ Instance fields
	// -----------------------------------------------------

	private static final int INDEX_MAX = 10000;
	protected HierarchyContext context = null;
	protected boolean register = true;
	private ArrayList intAndStrList = new ArrayList(INDEX_MAX);
	private ArrayList featureList = new ArrayList();
	private ArrayList containerList = new ArrayList();
	private StringBuffer result = new StringBuffer();
	private HashMap objectIndexes;
	public HierarchyXMIResourceImpl() {
		super();

		initHierarchyResource();
	}

	public HierarchyXMIResourceImpl(URI uri) {
		super(uri);

		initHierarchyResource();
	}

	//~ Methods
	// ------------------------------------------------------------------------------------

	public EObject getEObject(String uriFragment) {
		if (!isPath(uriFragment)) {
			if (idToEObjectMap != null) {
				EObject eObject = (EObject) idToEObjectMap.get(uriFragment);

				return eObject;
			} else {
				return null;
			}
		}

		return super.getEObject(uriFragment);
	}

	public String getIndexStr(int index) {
		// index String slot size
		//   0 "0" 0 1
		//   1 "1" 1 2
		//   2 "2" 2 3
		int size = intAndStrList.size();

		if (index >= size) {
			intAndStrList.ensureCapacity(index + 1);

			for (int i = size; i < index; i++) {
				intAndStrList.add(i, null);
			}

			String indexStr = Integer.toString(index);

			intAndStrList.add(index, indexStr);

			return indexStr;
		}

		if (intAndStrList.get(index) == null) {
			String indexStr = Integer.toString(index);

			intAndStrList.set(index, indexStr);

			return indexStr;
		}

		return (String) intAndStrList.get(index);
	}

	public String getURIFragment(EObject eObject) {
		String id = EcoreUtil.getID(eObject);

		if (id != null) {
			return id;
		} else {
			result.setLength(0);

			for (EObject container = eObject.eContainer(); container != null;
			container = eObject.eContainer()) {
				EStructuralFeature eStructuralFeature = eObject.eContainmentFeature();

				if (eStructuralFeature.isMany()) {
					org.eclipse.emf.common.util.EList eList = (org.eclipse.emf.common.util.EList) container.eGet(eStructuralFeature, false);
					int index = eList.indexOf(eObject);

					if (index < 10000) {
						result.insert(0, getIndexStr(index));
					} else {
						result.insert(0, index);
					}

//					addIndex(eList,eObject);
					
					result.insert(0, '.');
					result.insert(0, eStructuralFeature.getName());
					result.insert(0, '@');
				} else {
					result.insert(0, eStructuralFeature.getName());
					result.insert(0, '@');
				}

				result.insert(0, '/');
				eObject = container;
			}

			result.insert(0, getURIFragmentRootSegment(eObject));
			result.insert(0, '/');

			return result.toString();
		}
	}
	

	/**
	 * @param list
	 * @param object
	 * @return
	 */
	private void addIndex(EList list, EObject object) {
		if(list.size()<10000)
		{
			int index = list.indexOf(object);
			if (index < 10000) {
				result.insert(0, getIndexStr(index));
			} else {
				result.insert(0, index);
			}
			return;
		}

		IndexHashTable objects = (IndexHashTable)objectIndexes.get(list);
		if(objects==null)
		{
			objects = new IndexHashTable();
		}
		else
		{
			int index = objects.get(object);
			if(index!=-1)
			{
				result.insert(0,index);
				return;
			}
		}

		int index = list.indexOf(object);
		if (index < 10000) {
			result.insert(0, getIndexStr(index));
		} else {
			result.insert(0, index);
		}
		objects.put(object,index);
		return;
	}

	/**
	 * @see org.eclipse.emf.ecore.resource.Resource.Internal#attached(org.eclipse.emf.ecore.EObject)
	 */
	public void attached(EObject value) {
		if (register) {
			LookupServiceExtensions.getInstance().register(
				getContext(value),
				value);
		}
	}

	/**
	 * @see org.eclipse.emf.ecore.resource.Resource.Internal#detached(org.eclipse.emf.ecore.EObject)
	 */
	public void detached(EObject value) {
		LookupServiceExtensions.getInstance().deregister(
			getContext(value),
			value);
	}

	public void doLoad(InputStream inputStream, Map options)
		throws IOException {
		PerfUtil p = new PerfUtil("HierarchyXMIResourceImpl.doLoad() uri="+getURI(),true);

		try {
			register = false;
			super.doLoad(inputStream, options);

			ContainmentTraverser containmentTraverser =
				new ContainmentTraverser(getContents());

			EObjectVisitor objectVisitor = new EObjectVisitor() {
				public boolean afterChildren(EObject element) {
					return true;
				}

				public boolean beforeChildren(EObject element) {
					LookupServiceExtensions.getInstance().register(
						getContext(element),
						element);

					return true;
				}
			};

			containmentTraverser.registerVisitors(objectVisitor);

			containmentTraverser.traverse();

			register = true;
			
		} catch (IOException e) {
			p.stopAndPrintStatus(e.getLocalizedMessage());
			throw e;
		}
		p.stopAndPrintStatus(Arrays.asList(new Throwable().getStackTrace()).toString());
	}

	/**
	 * This method deletes the resource and cleanup the memory.
	 * @deprecated Use delete() method instead.
	 *  
	 */
	public void doShallowDelete() {
		unloadLookupContext();
		for (Iterator iter = EMFUtil.delete(this).iterator();
			iter.hasNext();
			) {
			Resource res = (Resource) iter.next();

			if (res != null) {
				res.setModified(true);
			}
		}

		if ((context != null) && (context.getAgentProxy() != null)) {
			context.getAgentProxy().setAgent(null);
		}

		//        SaveUtil.removeDocument(this);
	}

	public void doShallowUnload() {
		unloadLookupContext();
		EMFUtil.unload(this);
		//        SaveUtil.removeDocument(this);
	}

	/**
	 * @return
	 */
	protected HierarchyContext getContext(EObject object) {
		//        context = (HierarchyContext)
		// LookupServiceExtensions.getInstance().locate(null,
		// HierarchyContext.class, getURI().toString());
		if ((context == null) && object instanceof TRCAgent) {
			context =
				(HierarchyContext) LookupServiceExtensions
					.getInstance()
					.locate(
					null,
					HierarchyContext.class,
					getURI().toString());

			if (context == null) {
				context = new HierarchyContext();
			}

			TRCAgent agent = (TRCAgent) object;

			AgentsContext agentsContext =
				(AgentsContext) LookupServiceExtensions.getInstance().locate(
					null,
					AgentsContext.class,
					LoadersUtils.getLookUpKey(agent.getRuntimeId()));

			if (agentsContext == null) {
				agentsContext = new AgentsContext(agent.getRuntimeId());
				LookupServiceExtensions.getInstance().register(
					null,
					agentsContext);
			}

			agentsContext.registerAgent(agent);

			context.setAgent(agent);
			context.setContextURI(getURI().toString());
			LookupServiceExtensions.getInstance().register(null, context);

			return null;
		} else if (object instanceof UnresolvedCorrelation) {
			return null; //this should be added to the global context
		}

		return context;
	}

	protected XMLLoad createXMLLoad() {
		XMLResourceLoader resourceLoader = null;

		try {
			resourceLoader =
				(XMLResourceLoader) ResourceExtensions.getInstance().get(
					getURI().fileExtension());

			if (resourceLoader != null) {
				resourceLoader =
					(XMLResourceLoader) resourceLoader.getClass().newInstance();
				resourceLoader.setXMLHelper(createXMLHelper());
			}
		} catch (Exception e) {
			HierarchyPlugin.log(e.getLocalizedMessage());
		}

		if (resourceLoader == null) {
			return super.createXMLLoad();
		}

		return resourceLoader;
	}

	/**
	 * @see org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl#createXMLSave()
	 */
	protected XMLSave createXMLSave() {
		return new HierarchyXMISaveImpl(createXMLHelper());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#doUnload()
	 */
	protected void doUnload() {
		PerfUtil p = new PerfUtil("HierarchyXMIResourceImpl.doUnload() uri="+getURI(),true);
		doShallowUnload();
		p.stopAndPrintStatus();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl#doSave(java.io.OutputStream, java.util.Map)
	 */
	public void doSave(OutputStream outputStream, Map options) throws IOException {
		PerfUtil p = new PerfUtil("HierarchyXMIResourceImpl.doSave() uri="+getURI(),true);

		try {
			super.doSave(outputStream, options);
		} catch (IOException e) {
			p.stopAndPrintStatus(e.getLocalizedMessage());
			throw e;
		}
		p.stopAndPrintStatus();
	}

	protected void unloadLookupContext() {
		if (context != null) {
			if (context.getAgent() != null) {
				//                LookupServiceExtensions.getInstance().deregister(null,
				// TRCAgentImpl.class, context.getAgent().getRuntimeId());
				TRCAgent agent = context.getAgent();
				AgentsContext agentsContext =
					(AgentsContext) LookupServiceExtensions
						.getInstance()
						.locate(
						null,
						AgentsContext.class,
						LoadersUtils.getLookUpKey(agent.getRuntimeId()));

				if (agentsContext != null) {
					agentsContext.deregisterAgent(agent);
				}

				deregisterContents(getContents());
			}

			LookupServiceExtensions.getInstance().deregister(context);
			LookupServiceExtensions.getInstance().deregister(
				null,
				HierarchyContext.class,
				getURI().toString());
			context = null;
		}
	}

	private void deregisterContents(List l) {
		ContainmentTraverser containmentTraverser = new ContainmentTraverser(l);

		EObjectVisitor objectVisitor = new EObjectVisitor() {
			public boolean afterChildren(EObject element) {
				LookupServiceExtensions.getInstance().deregister(
					context,
					element);

				return true;
			}

			public boolean beforeChildren(EObject element) {
				return true;
			}
		};

		containmentTraverser.registerVisitors(objectVisitor);

		containmentTraverser.traverse();
	}

	private void initHierarchyResource() {
		for (int i = 0; i < INDEX_MAX; i++) {
			intAndStrList.add(i, null);
		}
	}
//	/* (non-Javadoc)
//	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#doSave(java.io.OutputStream, java.util.Map)
//	 */
//	public void doSave(OutputStream outputStream, Map options)
//		throws IOException {
//		objectIndexes = new HashMap(); 
//		super.doSave(outputStream, options);
//		objectIndexes=null; 
//	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.HyadesResource#delete()
	 */
	public boolean delete() {
		PerfUtil p = new PerfUtil("HierarchyXMIResourceImpl.delete() uri="+getURI(),true);
		doShallowDelete();
		p.stopAndPrintStatus();
		return true;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.HyadesResource#deleteObjects(org.eclipse.emf.common.util.EList)
	 */
	public boolean deleteObjects(EList uris) {
		throw new UnsupportedOperationException(Constants.NOT_IMPLEMENTED_YET);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.HyadesResource#unloadObjects(org.eclipse.emf.common.util.EList)
	 */
	public boolean unloadObjects(EList uris) {
		throw new UnsupportedOperationException(Constants.NOT_IMPLEMENTED_YET);
	}
//	/* (non-Javadoc)
//	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#doSave(java.io.OutputStream, java.util.Map)
//	 */
//	public void doSave(OutputStream outputStream, Map options)
//		throws IOException {
//		objectIndexes = new HashMap(); 
//		super.doSave(outputStream, options);
//		objectIndexes=null; 
//	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#isContentZipEntry(java.util.zip.ZipEntry)
	 */
//	protected boolean isContentZipEntry(ZipEntry zipEntry) {
//		if(zipEntry.getName().equals(super.newContentZipEntry().getName()))
//			return super.isContentZipEntry(zipEntry);
//		else 
//			return false;
//	}
//	
//	/* (non-Javadoc)
//	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#newContentZipEntry()
//	 */
//	protected ZipEntry newContentZipEntry() {
//		if(!getURI().hasQuery())
//			return super.newContentZipEntry();
//		else
//			return null;
//	}
	
}
