/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExtendedQueryService.java,v 1.8 2005/03/16 19:35:58 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Collection;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;

/**
 * @author slavescu
 */
public interface IExtendedQueryService {
	QueryResult executeQuery(Query query,ResourceSet targetResourceSet, Collection notLoadedTypes);
	QueryResult executeQuery(String queryName,ResourceSet targetResourceSet, Collection notLoadedTypes);
	boolean validateQuery(Query query);
	boolean storeQuery(Query query);
}
