/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PerfUtil.java,v 1.7 2005/04/28 16:27:51 slavescu Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.models.hierarchy.util;
import java.io.PrintStream;
import java.util.HashMap;
public class PerfUtil {
	/**
	 * 
	 */
	public PerfUtil() {
		super();
	}
	long startTime, stopTime;
	long startTotMem, startFreeMem, stopTotMem, stopFreeMem;
	private String msg;
	private boolean debug=false;
	private static HashMap registry;

	public PerfUtil(String msg,boolean start) {
		setDebugFlag();
		if(!debug)
			return;
		this.msg = msg;
		if(start)
			start();
	}
	/**
	 * 
	 */
	private void setDebugFlag() {
		try {
			 String s = System.getProperties().getProperty("PerfUtil.debug"); // use -DPerfUtil.debug=true on VMARGS to enable the probes
			 if(Boolean.valueOf(s).booleanValue())
			 {
			 	debug=true;
			 }
			 if(!debug)
				debug = ModelDebugger.INSTANCE.debugPerfUtil;
		} catch (Exception e) {
			//ignore and let debug on default
		}
	}
	public void start() {
		if(!debug)
			return;
		startTime = System.currentTimeMillis();
		stopTime = startTime;
		//		  Runtime.getRuntime().gc();
		startTotMem = Runtime.getRuntime().totalMemory();
		startFreeMem = Runtime.getRuntime().freeMemory();
	}
	public void stop() {
		if(!debug)
			return;
		stopTime = System.currentTimeMillis();
		//	      Runtime.getRuntime().gc();
		stopTotMem = Runtime.getRuntime().totalMemory();
		stopFreeMem = Runtime.getRuntime().freeMemory();
	}
	public long getTime() {
		return stopTime - startTime;
	}
	public void printStatus() {
		printStatus(System.out);
	}
	public void printStatus(String m) {
		if(!debug)
			return;
		this.msg+=", "+m;
		printStatus(System.out);
	}
	public void printStatus(PrintStream out) {
		if(debug)
			out.println(msg + ": deltaTime=" + getTime() + " - stopTime=" + stopTime + " - usedMemoryDelta=" + getUsedMemoryDelta() +" - freeMemoryDelta=" + getFreeMemoryDelta()+ " - totalMemoryDelta=" + getTotalMemoryDelta() + " - usedMemoryAfter=" + (stopTotMem-stopFreeMem)+ " - freeMemoryAfter=" + stopFreeMem +" - totalMemoryAfter=" + stopTotMem);
	}
	/**
	 * @return
	 */
	public long getUsedMemoryDelta() {
		return (stopTotMem-stopFreeMem)-(startTotMem-startFreeMem);
	}
	/**
	 * @return
	 */
	public long getTotalMemoryDelta() {
		return stopTotMem - startTotMem;
	}
	public long getFreeMemoryDelta() {
		return stopFreeMem - startFreeMem;
	}
	/**
	 * @param string
	 */
	public void setMessage(String msg) {
		if(!debug)
			return;
		this.msg= msg;
	}
	/**
	 * @return Returns the msg.
	 */
	public String getMessage() {
		return msg;
	}
	/**
	 * @param string
	 */
	public void setMessageAndStart(String string) {
		if(!debug)
			return;
		setMessage(string);
		start();
	}
	public void stopAndPrintStatus() {
		if(!debug)
			return;
		stop();
		printStatus();
	}
	public void stopAndPrintStatus(String msg) {
		if(!debug)
			return;
		this.msg+=", "+msg;
		stop();
		printStatus();
	}
	
	public static PerfUtil getPerfUtil(Object key)
	{
		PerfUtil res = (PerfUtil)registry.get(key);
		if(res == null)
		{
			res = new PerfUtil(key.toString(),false);
			registry.put(key,res);
		}
		return res;
	}
	public static PerfUtil removePerfUtil(Object key)
	{
		PerfUtil res = (PerfUtil)registry.get(key);
		if(res != null)
		{
			registry.remove(key);
		}
		return res;
	}
	/**
	 * @return Returns the debug.
	 */
	public boolean isDebug() {
		return debug;
	}
	/**
	 * @param debug The debug to set.
	 */
	public void setDebug(boolean debug) {
		this.debug = debug;
	}
}