/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ImportFilterEngine.java,v 1.3 2005/03/30 04:14:19 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;

/**
 * @author Marius Slavescu (slavescu@ca.ibm.com)
 * @since 3.3
 * 
 */
public class ImportFilterEngine extends SimpleSearchQueryEngine{

	protected Map includeIdsByFeatureIndex=new HashMap();
	protected Map excludeIdsByFeatureIndex=new HashMap();
	protected EvalResult evalResult;
	
	public ImportFilterEngine(SimpleSearchQuery query,ResourceSet targetResourceSet) {
		super(convertQuery(query),targetResourceSet);
	}

	private static SimpleSearchQuery convertQuery(SimpleSearchQuery query) {
		WhereExpression expression = query.getWhereExpression();
		if(expression instanceof LogicalExpression)
		{
			LogicalExpression orLogicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
			orLogicalExpression.setOperator(LogicalOperators.OR_LITERAL);
			Set be = new HashSet();
			for (Iterator iter = ((LogicalExpression)expression).eAllContents(); iter.hasNext();) {
				EObject element = (EObject) iter.next();
				if(element instanceof BinaryExpression)
				{
					be.add(element);
				}
			}
			for (Iterator iter = be.iterator(); iter.hasNext();) {
				BinaryExpression element = (BinaryExpression) iter.next();
				orLogicalExpression.getArguments().add(element);
			}
			query.setWhereExpression(orLogicalExpression);
		}
		return query;
	}

	public boolean isFiltered(EStructuralFeature sf, Object id, Object value) {
		if(query==null)
			return false;
		if(value!=null)
		{
			return evaluateAndUpdateIndexes(sf,id,value);
		}
		else
			return internalIsFiltered(sf,id);
	}

	protected boolean internalIsFiltered(EStructuralFeature sf, Object id) {
		Set ids = (Set)includeIdsByFeatureIndex.get(sf);
		if(ids!=null && ids.contains(id))
			return false;
		return true;
	}

	protected boolean evaluateAndUpdateIndexes(EStructuralFeature sf, Object id, Object value) {
		if(evaluate(sf,id,value))
		{
			Set ids = (Set)includeIdsByFeatureIndex.get(sf);
			if(ids==null)
			{
				ids = new HashSet();
				includeIdsByFeatureIndex.put(sf,ids);
			}
			ids.add(id);
			return false;
		}
		return true;
	}

	protected boolean evaluate(EStructuralFeature sf, Object id, Object value) {
		evalResult.evalOnly(sf, value);
		if(evalResult.isComplete())
		{
			if(evalResult.booleanValue.booleanValue())
			{
				evalResult.resetOnly(sf);
				return true;
			}
		}
		evalResult.resetOnly(sf);
		return false;
	}

	public boolean isFiltered(EStructuralFeature sf, Object id) {
		if(query==null)
			return false;
		return internalIsFiltered(sf,id);
	}
	
	public void init() {
		prepareResult();
		populateRootNodesAndClasses();
		buildRequiredTraversalPaths();
		indexWhereExpression();
		prepareEvalResult();
	}

	protected void prepareEvalResult() {
		SimpleSearchQueryEvaluator queryEvaluator = new SimpleSearchQueryEvaluator();
		evalResult = queryEvaluator.prepareEvalResult();
	}

//	public void filterOut(EAttribute class_Name, Object lookUpKey) {
//		
//	}
}
