package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IConfigureSituation.java,v 1.4 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The ConfigureSituation deals with the components identifying their configuration. 
 * Any changes that a component makes to its configuration should be logged using 
 * this category. Additionally, messages that describe current configuration state 
 * fall into this category. Existing message include words like port number is, 
 * address is, and process id, for example:
 * 
 * <code>
 * ADFS0134I: File transfer is configured with host="9.27.11.13", port="9090", securityEnabled="false"
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IConfigureSituation extends ISituationType {

    /**
     * Returns the successDisposition.
     * 
     * This property specifies the success disposition of an operation of a 
     * situation that caused the situation to be reported.  The successDisposition 
     * is a string with the following set of values:
     * 
     * SUCCESSFUL
     * UNSUCESSFUL
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned successDisposition.
     * @since 1.0.1
     */
    public String getSuccessDisposition();

    /**
     * Sets the successDisposition.
     * 
     * This property specifies the success disposition of an operation of a 
     * situation that caused the situation to be reported.  The successDisposition 
     * is a string with the following set of values:
     * 
     * SUCCESSFUL
     * UNSUCESSFUL
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param successDisposition The successDisposition to be set.
     * @since 1.0.1
     */
    public void setSuccessDisposition(String successDisposition);
}
