package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IOtherSituation.java,v 1.4 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The OtherSituation category is to provide support for the situation that is 
 * product specific requirement other than the predefined categories.
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IOtherSituation extends ISituationType {

    /**
     * Returns the anyData.
     * 
     * Any other situation that is product specific requirement other than the 
     * predefined categories.
     * 
     * @return String The returned anyData.
     * @since 1.0.1
     */
    public String[] getAnyData();
    
    /**
     * Sets the anyData.
     * 
     * Any other situation that is product specific requirement other than the 
     * predefined categories.
     * 
     * @param anyData The anyData to be set.
     * @since 1.0.1
     */
    public void setAnyData(String[] anyData);
}
