package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MsgCatalogTokenImpl.java,v 1.4 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * A representation of the 'Msg Catalog Token'. A string used as substitution 
 * value for resolving an internationalized message into formatted text. 
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see IMsgCatalogToken 
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public class MsgCatalogTokenImpl implements IMsgCatalogToken, Serializable, Cloneable {

    //Define the serialiVersionUID for serialization:
    //NOTE: If this object is ever changed which breaks backward compatibility,
    //this value MUST be changed.  Every effort should be made not to break 
    //backward compatibility.
    static final long serialVersionUID = -3888096669772662967L;

    //Define the fields that will be serialized: 
    //NOTE: If any new variables are added to the class this table should be 
    //updated along with the readObject and writeObject methods.
    private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("value", String.class)};

    //Class instance variable(s):
    protected String value = null;

    /**
     * No-argument protected constructor for MsgCatalogTokenImpl.
     */
    protected MsgCatalogTokenImpl() {
        super();
    }

    /**
     * Returns the value.
     * 
     * The value of the message catalog token.
     * 
     * @return String The value.
     * @see org.eclipse.hyades.logging.events.IMsgCatalogToken#getValue()
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value.
     * 
     * The value of the message catalog token.
     * 
     * @param value The value to set.
     * @see org.eclipse.hyades.logging.events.IMsgCatalogToken#setValue(java.lang.String)
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Determines is two different objects are equal.
     */
    public boolean equals(Object obj) {

        //It's the same object reference, so it HAS to be equal
        if (this == obj) {
            return true;
        }
        else {

            //If the object is null or is not the correct type of object, it can't be
            //equal
            if ((obj != null) && (obj instanceof MsgCatalogTokenImpl) && (getClass() == obj.getClass())) {

                MsgCatalogTokenImpl contextDataElement = (MsgCatalogTokenImpl) obj;

                Object property1;
                Object property2;

                property1 = getValue();
                property2 = contextDataElement.getValue();

                if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                    return true;
                }
            }
        }

        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {

        // set the values of the Serializable fields
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("value", value);

        // save them
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {

        // prepare to read the alternate persistent fields
        ObjectInputStream.GetField fields = null;
        fields = in.readFields();

        // read the alternate persistent fields
        value = (String) fields.get("value", value);
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {
        return (super.clone());
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @since 1.0.1
     * @see org.eclipse.hyades.logging.events.IMsgCatalogToken#init()
     */
    public void init() {
        value = null;
    }
}
