package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SituationImpl.java,v 1.8 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Taken from "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 * 
 * The situation specifies the type of the situation that caused the event 
 * to be reported. The situation is the data that describes the situation 
 * or event reported by the event.  The situation information includes a required 
 * set of properties or attributes that are common across products groups and platforms, 
 * yet architected and flexible to allow for adoption to product-specific requirements. 
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituation
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public class SituationImpl implements ISituation, Serializable, Cloneable {

    //Define the serialiVersionUID for serialization:
    //NOTE: If this object is ever changed which breaks backward compatibility,
    //this value MUST be changed.  Every effort should be made not to break 
    //backward compatibility.
    static final long serialVersionUID = -3888096669772662967L;

    //Define the fields that will be serialized: 
    //NOTE: If any new variables are added to the class this table should be 
    //updated along with the readObject and writeObject methods.
    private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("categoryName", String.class), new ObjectStreamField("situationType", ISituationType.class)};

    //Class instance variable(s):
    protected String categoryName = null;
    protected ISituationType situationType = null;

    /**
     * No-argument protected constructor for SituationImpl.
     */
    protected SituationImpl() {
        super();
    }

    /**
      * Returns the situationType.
      * 
      * The situationType specifies the type of the situation that caused 
      * the event to be reported. See SituationType definition for details.
      * This is an REQUIRED property. 
      * 
      * @return String The returned situationType.
      * @since 1.0.1
      */
    public ISituationType getSituationType() {
        return situationType;
    }

    /**
     * Returns the categoryName.
     * 
     * The categoryName specifies the type of the situation that caused the event to be reported.  
     * The categoryName is a string and has the following set of values: 
     * 
     * StartSituation
     * StopSituation
     * ConnectSituation
     * ConfigureSituation
     * RequestSituation
     * FeatureSituation
     * DependencySituation
     * CreateSituation
     * DestroySituation
     * ReportSituation
     * AvailableSituation
     * OtherSituation
     * 
     * This is a REQUIRED property. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned categoryName.
     * @since 1.0.1
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * Sets the situationType.
     * 
     * The situationType specifies the type of the situation that caused 
     * the event to be reported. See SituationType definition for details.
     * This is an REQUIRED property. 
     * 
     * @param situationType The situationType to be set.
     * @since 1.0.1
     */
    public void setSituationType(ISituationType situationType) {
        this.situationType = situationType;
    }

    /**
     * Sets the categoryName.
     * 
     * The categoryName specifies the type of the situation that caused the event to be reported.  
     * The categoryName is a string and has the following set of values: 
     * 
     * StartSituation
     * StopSituation
     * ConnectSituation
     * ConfigureSituation
     * RequestSituation
     * FeatureSituation
     * DependencySituation
     * CreateSituation
     * DestroySituation
     * ReportSituation
     * AvailableSituation
     * OtherSituation
     * 
     * This is a REQUIRED property. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param categoryName The categoryName to be set.
     * @since 1.0.1
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        //Check if the parameter object is the same object reference as this object (e.g. equal):
        if (this == object)
            return true;

        else {

            //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
            if ((object != null) && (getClass() == object.getClass())) {

                SituationImpl situationImpl = ((SituationImpl) (object));

                //Compare the value(s) of all object properties:
                Object thisObjectsProperty = getCategoryName();
                Object parameterObjectsProperty = situationImpl.getCategoryName();

                if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {

                    thisObjectsProperty = getSituationType();
                    parameterObjectsProperty = situationImpl.getSituationType();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null)))
                        return true;
                }
            }
        }

        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {

        //Set the values of the serializable field(s):
        ObjectOutputStream.PutField fields = out.putFields();

        fields.put("categoryName", categoryName);
        fields.put("situationType", situationType);

        //Write the values of the serializable field(s):
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {

        //Prepare and read the alternate persistent field(s):
        ObjectInputStream.GetField fields = null;

        fields = in.readFields();

        //Retrieve the alternate persistent field(s):
        categoryName = ((String) (fields.get("categoryName", categoryName)));
        situationType = ((ISituationType) (fields.get("situationType", situationType)));
    }

    /**
     * Return a clone (copy by value) of this object. This is a deep copy version, 
     * in which all the objects within this object will be copied by value.
     *  
     * @return Object The clone of this object.
     */
    public Object clone() throws CloneNotSupportedException {

        SituationImpl copy = ((SituationImpl) (super.clone()));

        if (this.situationType instanceof SituationTypeImpl) {
            copy.situationType = ((ISituationType) ((SituationTypeImpl) (this.situationType)).clone());
        }

        return copy;
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @see org.eclipse.hyades.logging.events.ISituation#init()
     */
    public void init() {

        categoryName = null;
        situationType = null;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setAvailableSituation(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    public void setAvailableSituation(String reasoningScope, String availabilityDisposition, String operationDisposition, String processingDisposition) {

        IAvailableSituation availableSituation = new AvailableSituationImpl();

        availableSituation.setReasoningScope(reasoningScope);
        availableSituation.setAvailabilityDisposition(availabilityDisposition);
        availableSituation.setOperationDisposition(operationDisposition);
        availableSituation.setProcessingDisposition(processingDisposition);

        setSituationType(availableSituation);
        setCategoryName(AVAILABLE_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setConfigureSituation(java.lang.String, java.lang.String)
     */
    public void setConfigureSituation(String reasoningScope, String successDisposition) {

        IConfigureSituation configureSituation = new ConfigureSituationImpl();

        configureSituation.setReasoningScope(reasoningScope);
        configureSituation.setSuccessDisposition(successDisposition);

        setSituationType(configureSituation);
        setCategoryName(CONFIGURE_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setConnectSituation(java.lang.String, java.lang.String, java.lang.String)
     */
    public void setConnectSituation(String reasoningScope, String situationDisposition, String successDisposition) {

        IConnectSituation connectSituation = new ConnectSituationImpl();

        connectSituation.setReasoningScope(reasoningScope);
        connectSituation.setSituationDisposition(situationDisposition);
        connectSituation.setSuccessDisposition(successDisposition);

        setSituationType(connectSituation);
        setCategoryName(CONNECT_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setCreateSituation(java.lang.String, java.lang.String)
     */
    public void setCreateSituation(String reasoningScope, String successDisposition) {

        ICreateSituation createSituation = new CreateSituationImpl();

        createSituation.setReasoningScope(reasoningScope);
        createSituation.setSuccessDisposition(successDisposition);

        setSituationType(createSituation);
        setCategoryName(CREATE_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setDependencySituation(java.lang.String, java.lang.String)
     */
    public void setDependencySituation(String reasoningScope, String dependencyDisposition) {

        IDependencySituation dependencySituation = new DependencySituationImpl();

        dependencySituation.setReasoningScope(reasoningScope);
        dependencySituation.setDependencyDisposition(dependencyDisposition);

        setSituationType(dependencySituation);
        setCategoryName(DEPENDENCY_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setDestroySituation(java.lang.String, java.lang.String)
     */
    public void setDestroySituation(String reasoningScope, String successDisposition) {

        IDestroySituation destroySituation = new DestroySituationImpl();

        destroySituation.setReasoningScope(reasoningScope);
        destroySituation.setSuccessDisposition(successDisposition);

        setSituationType(destroySituation);
        setCategoryName(DESTROY_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setFeatureSituation(java.lang.String, java.lang.String)
     */
    public void setFeatureSituation(String reasoningScope, String featureDisposition) {

        IFeatureSituation featureSituation = new FeatureSituationImpl();

        featureSituation.setReasoningScope(reasoningScope);
        featureSituation.setFeatureDisposition(featureDisposition);

        setSituationType(featureSituation);
        setCategoryName(FEATURE_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setOtherSituation(java.lang.String, java.lang.String)
     */
    public void setOtherSituation(String reasoningScope, String any) {

        IOtherSituation otherSituation = new OtherSituationImpl();

        otherSituation.setReasoningScope(reasoningScope);
        otherSituation.setAnyData(new String[] { any });

        setSituationType(otherSituation);
        setCategoryName(OTHER_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setReportSituation(java.lang.String, java.lang.String)
     */
    public void setReportSituation(String reasoningScope, String reportCategory) {

        IReportSituation reportSituation = new ReportSituationImpl();

        reportSituation.setReasoningScope(reasoningScope);
        reportSituation.setReportCategory(reportCategory);

        setSituationType(reportSituation);
        setCategoryName(REPORT_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setRequestSituation(java.lang.String, java.lang.String, java.lang.String)
     */
    public void setRequestSituation(String reasoningScope, String situationQualifier, String successDisposition) {

        IRequestSituation requestSituation = new RequestSituationImpl();

        requestSituation.setReasoningScope(reasoningScope);
        requestSituation.setSituationQualifier(situationQualifier);
        requestSituation.setSuccessDisposition(successDisposition);

        setSituationType(requestSituation);
        setCategoryName(REQUEST_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setStartSituation(java.lang.String, java.lang.String, java.lang.String)
     */
    public void setStartSituation(String reasoningScope, String situationQualifier, String successDisposition) {

        IStartSituation startSituation = new StartSituationImpl();

        startSituation.setReasoningScope(reasoningScope);
        startSituation.setSituationQualifier(situationQualifier);
        startSituation.setSuccessDisposition(successDisposition);

        setSituationType(startSituation);
        setCategoryName(START_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ISituation#setStopSituation(java.lang.String, java.lang.String, java.lang.String)
     */
    public void setStopSituation(String reasoningScope, String situationQualifier, String successDisposition) {

        IStopSituation stopSituation = new StopSituationImpl();

        stopSituation.setReasoningScope(reasoningScope);
        stopSituation.setSituationQualifier(situationQualifier);
        stopSituation.setSuccessDisposition(successDisposition);

        setSituationType(stopSituation);
        setCategoryName(STOP_SITUATION_CATEGORY);
    }
}
