package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SituationTypeImpl.java,v 1.6 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Taken from "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 * 
 * The situationType specifies the type or category of the situation that caused 
 * the event to be reported. The categorization of situations facilitates the building 
 * of tools that focus on implementing the analysis and planning functions rather than 
 * on product-specific data formats.  The data type for this property is a complex type. 
 * The situation types or categories are defined below. SituationType is an abstract 
 * element that is used to define all supported situation types (i.e. StartSituation, 
 * StopSituation, etc).
 * 
 * The simplest way to understand the usefulness of categorization is by providing a use 
 * case.  For example, assume that a problem has been detected with component A. The 
 * first step in the root cause analysis might be to check to see if x was actually 
 * started, since it is known that A has a dependency on x. One approach to determine 
 * if x is running is to check the log file for x to see if it has started. The problem 
 * from a programmatic perspective is that there is not standard way to check the log files 
 * to see if x has started.  x might log Component x started or it might say, 
 * Change server state from starting to running.  The reality is that both of these messages 
 * provide the same information, but they provide it using different terminology, making it 
 * difficult for a program to use. Simple checks like this would be much easier if all components 
 * reported, for example, that they started. Writing code to check dependencies would be much 
 * easier and would be, largely, component independent. For example, if product A had dependencies 
 * on x and y, the code to check the status of x and the code to check the status of y 
 * would be the same, in both cases, it would look for a started message.
 * 
 * This is a REQUIRED property, that once it set it is not mutable, that is it MUST NOT be changed.
 * The following sections outline the well-known and acceptable values for the situationType.
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public abstract class SituationTypeImpl implements ISituationType, Serializable, Cloneable {

    //Define the serialiVersionUID for serialization:
    //NOTE: If this object is ever changed which breaks backward compatibility,
    //this value MUST be changed.  Every effort should be made not to break 
    //backward compatibility.
    static final long serialVersionUID = -3888096669772662967L;

    //Define the fields that will be serialized: 
    //NOTE: If any new variables are added to the class this table should be 
    //updated along with the readObject and writeObject methods.
    private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("reasoningScope", String.class)};

    //Class instance variable(s):
    protected String reasoningScope = null;

    /**
     * No-argument protected constructor for SituationTypeImpl.
     */
    protected SituationTypeImpl() {
		super();
    }

    /**
     * Returns the reasoningScope.
     * 
     * This property specifies the situation qualifiers that are representation 
     * of the parameters necessary to describe the situation.
     * The reasoningScope is a string with the following set of values:
     * 
     * START INITIATED
     * RESTART INITIATED
     * START COMPLETED
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned reasoningScope.
     * @since 1.0.1
     */
    public String getReasoningScope() {
        return reasoningScope;
    }

    /**
     * Sets the reasoningScope.
     * 
     * This property specifies the situation qualifiers that are representation 
     * of the parameters necessary to describe the situation.
     * The reasoningScope is a string with the following set of values:
     * 
     * START INITIATED
     * RESTART INITIATED
     * START COMPLETED
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param reasoningScope The reasoningScope to be set.
     * @since 1.0.1
     */
    public void setReasoningScope(String reasoningScope) {
        this.reasoningScope = reasoningScope;
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        //Check if the parameter object is the same object reference as this object (e.g. equal):
        if (this == object)
            return true;

        else {

            //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
            if ((object != null) && (getClass() == object.getClass())) {

                //Compare the value(s) of all object properties:
                String thisObjectsProperty = getReasoningScope();
                String parameterObjectsProperty = ((SituationTypeImpl) (object)).getReasoningScope();

                if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null)))
                    return true;
            }
        }

        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {

        //Set the values of the serializable field(s):
        ObjectOutputStream.PutField fields = out.putFields();

        fields.put("reasoningScope", reasoningScope);

        //Write the values of the serializable field(s):
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {

        //Prepare and read the alternate persistent field(s):
        ObjectInputStream.GetField fields = null;

        fields = in.readFields();

        //Retrieve the alternate persistent field(s):
        reasoningScope = ((String) (fields.get("reasoningScope", reasoningScope)));
    }

    /**
     * Return a clone (copy by value) of this object. This is a deep copy version, 
     * in which all the objects within this object will be copied by value.
     *  
     * @return Object The clone of this object.
     */
    public Object clone() throws CloneNotSupportedException {
        return (super.clone());
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @see org.eclipse.hyades.logging.events.ISituationType#init()
     */
    public void init() {
        reasoningScope = null;
    }
}
