/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ValueTooLongException.java,v 1.5 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.events.exceptions;

/**
 * @author lpurple
 * @deprecated This class is deprecated as of 2004-05-17
 *
 * Exception to indicate that a value was not supplied for a
 * required attribute, when calling a method or creating an object.
 */
public class ValueTooLongException extends Exception
{
    private String attribName;

    private int maxLength;

    /** Create a new ValueTooLongException.
     * 
     * @param attrName		The name of the attribute whose value
     * 						exceeds the allowable length.
     * 
     * @param maxLen		The maximum allowable length.
     */

    public ValueTooLongException(String attrName, int maxLen)
    {
        this.attribName = attrName;
        this.maxLength = maxLen;
    }

    /** Get the name of the attribute whose value exceeds the
     *  allowable length
     * 
     * @return		The attribute name.
     */
    public String getAttributeName()
    {
        return this.attribName;
    }

    /** Get the maximum allowable length for the attribute.
     * 
     * @return		The maximum allowable length.
     */
    public int getMaximumLength()
    {
        return this.maxLength;
    }

} /* end class ValueTooLongException */
