package org.eclipse.hyades.logging.java;

import java.util.logging.Level;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonBaseEventLevel.java,v 1.5 2005/04/28 13:30:16 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/** 
 * Extension of the Java Logging <code>java.util.logging.Level</code>
 * class used to create customized levels.
 * <p>
 * Users requiring logging levels not provided in the Java Logging 
 * <code>java.util.logging.Level</code> class should create a 
 * <code>org.eclipse.hyades.logging.java</code> using one of its constructors,
 * passing a symbolic name and associated numerical value for the newly
 * defined level.
 * <p>
 * Convenience static level objects are <b>not</b> provided by this 
 * extension class.  Application code leveraging this class should provide 
 * convenience static level objects relative to run-time logging instrumentation.
 * <p>
 * NOTE: The Java Logging classes must be on the CLASSPATH at run-time to
 * utilize this level class.
 * <p>
 *  
 * 
 * @author  Paul Slauenwhite
 * @version April 28, 2005
 * @since   April 15, 2004
 * @see     java.util.logging.Level
 */
public class CommonBaseEventLevel extends Level {

    /**
     * Stream-Unique IDentifier (SUID) of this class.
     * <p>
     * NOTE:  This value MUST not be modified unless an incompatible 
     *        change is introduced.  
     * <p>
     * See the 'Java Object Serialization Specification' for more details.
     * <p>
     * Compatible changes include:
     * <ul>
     * <li>Adding, modifying access or modifying <code>static</code>/<code>transient</code> to non-<code>static</code>/non-<code>transient</code> of fields.</li>
     * <li>Adding or removing classes.</li>
     * <li>Adding or removing <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>java.io.Serializable</code> inheritance.</li>
     * </ul>
     * <p>
     * Incompatible changes include:
     * <ul>
     * <li>Deleting, modifying non-<code>static</code>/non-<code>transient</code> to <code>static</code>/<code>transient</code> or modifying the declared type of fields.</li>
     * <li>Modifying the hierarchy or interchanging/removing <code>java.io.Serializable</code>/<code>java.io.Externalizable</code> inheritance of the class.</li>
     * <li>Modifying <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>writeReplace</code>/<code>readResolve</code> methods.</li>
     * </ul>
     */
    private static final long serialVersionUID = -8918320315827895999L;

    /**
     * Two parameter constructor for creating a customized level with a
     * symbolic name and associated numerical value.
     * <p>
     * 
     * @param name  The symbolic name of the newly defined level.
     * @param value The associated numerical value of the newly defined level.
     */
    public CommonBaseEventLevel(String name, int value){
        super(name,value);
    }

    /**
     * Three parameter constructor for creating a customized level with a
     * localized symbolic name and associated numerical value.
     * <p>
     * 
     * @param name  The key into the resource bundle to retrieve the symbolic name of the newly defined level.
     * @param value The associated numerical value of the newly defined level.
     * @param resourceBundleName The name of a local resource bundle to localize the newly defined level's name, otherwise null.
     */
    public CommonBaseEventLevel(String name, int value, String resourceBundleName){
        super(name,value,resourceBundleName);
    }
}
