/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteForm.java,v 1.5 2005/03/02 23:41:30 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

/**
 * @author marcelop
 * @since 1.0.2
 */
abstract public class TestSuiteForm 
extends EditorForm
{
	protected static final int HELP_FORM_CONTROL = 1;
	protected static final int HELP_TEST_CASE_CONTROL = 2;
	protected static final int HELP_TYPE_CONTROL = 3;
	protected static final int HELP_FILE_CASE_CONTROL = 4;
	
	private NamedElementSection namedElementSection;
	private NamedElementsSection testCaseElementsSection;

	private int testCasesPageIndex;


	/**
	 * Constructor for TestSuiteForm
	 * @param testSuiteEditorExtension
	 * @param widgetFactory
	 */
	public TestSuiteForm(BaseEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory)
	{
		super(testSuiteEditorExtension, widgetFactory);
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		namedElementSection.dispose();
		namedElementSection = null;
		
		testCaseElementsSection.dispose();
		testCaseElementsSection = null;
		
		super.dispose();
	}
	
	/**
	 * Returns the test case suite manipulated by this form.
	 * @return TPFTestSuite
	 */
	protected ITestSuite getTestSuite()
	{
		return ((IITestSuiteProvider)getBaseEditorExtension()).getTestSuite();		
	}
	
	/**
	 * Sets the index of the test case page that is presented when the "more" button
	 * of the test case section is pressed. 
	 * @param index
	 */
	public void setTestCasePageIndex(int index)
	{
		testCasesPageIndex = index;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);

		createLeftColumnControls(leftColumn);
		createRightColumnControls(rightColumn);
	}
	
	protected void createLeftColumnControls(Composite parent)
	{
		Control control = createGenericInformation(parent);
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
		registerHelp(HELP_FORM_CONTROL, control);
	}

	protected void createRightColumnControls(Composite parent)
	{
		testCaseElementsSection = new NamedElementsSection(getBaseEditorExtension(), testCasesPageIndex);
		registerSection(testCaseElementsSection);
		Control control = createTestCaseElementsSectionControl(parent, testCaseElementsSection);				
		registerHelp(HELP_TEST_CASE_CONTROL, control);
	}
	
	abstract protected Control createTestCaseElementsSectionControl(Composite parent, NamedElementsSection testCaseElementsSection);

	/**
	 * Creates the generic information form section.
	 * @return FormSection
	 */
	protected Control createGenericInformation(Composite parent)
	{
		namedElementSection = new NamedElementSection(this)
		{
			private StyledText typeText;
			private StyledText fileText;
			
			protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory)
			{
				Composite detailComposite = getWidgetFactory().createComposite(parent);
				GridLayout gridLayout = new GridLayout(2, false);
				gridLayout.marginHeight = 0;
				gridLayout.marginWidth = 0;
				detailComposite.setLayout(gridLayout);
				detailComposite.setLayoutData(GridDataUtil.createHorizontalFill());

				getWidgetFactory().createLabel(detailComposite, TestCommonPlugin.getString("L_TYPE"));
				typeText = getWidgetFactory().createStyledText(detailComposite, SWT.FULL_SELECTION | SWT.SINGLE);
				typeText.setEnabled(false);
				typeText.setLayoutData(GridDataUtil.createHorizontalFill());

				getWidgetFactory().createLabel(detailComposite, TestCommonPlugin.getString("L_FILE"));
				fileText = getWidgetFactory().createStyledText(detailComposite, SWT.FULL_SELECTION | SWT.SINGLE);
				fileText.setEnabled(false);
				fileText.setLayoutData(GridDataUtil.createHorizontalFill());
				
				registerHelp(HELP_TYPE_CONTROL, typeText);				
				registerHelp(HELP_TYPE_CONTROL, fileText);				
			}
			
			public void setInput(Object object)
			{
				super.setInput(object);
				
				String value = getTestSuite().getType();
				if(value != null)
				{
					IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS).getDefaultAssociationDescriptor(value);
					if((descriptor != null) && (descriptor.getName() != null))
						value = descriptor.getName();
					typeText.setText(value);
				}
				fileText.setText(EMFUtil.getFilePath((EObject)getTestSuite()));						
			}
		};
		registerSection(namedElementSection);		
		namedElementSection.setHeaderText(TestCommonPlugin.getString("EDT_GENERAL_INFO"));
		namedElementSection.setDescription(TestCommonPlugin.getString("EDT_GENERAL_DSC"));
		return namedElementSection.createControl(parent, getWidgetFactory());
	}

	protected void registerHelp(int flag, Object object)
	{
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		namedElementSection.setInput(getTestSuite());
		testCaseElementsSection.initialize((EObject)getTestSuite(), Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), null);
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#updateTitle()
	 */
	public void updateTitle()
	{
		Object editorObject = getBaseEditorExtension().getHyadesEditorPart().getEditorObject();
		if(editorObject instanceof IAdaptable)
		{
			String title = ((IWorkbenchAdapter)((IAdaptable)editorObject).getAdapter(IWorkbenchAdapter.class)).getLabel(editorObject);
			if(title != null)
				getBaseEditorExtension().getHyadesEditorPart().setTitle(title);
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		return true;
	}
}
