/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddBlockChildAction.java,v 1.3 2005/02/16 22:21:42 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.editor.action;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionListenerAction;

import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class AddBlockChildAction 
extends SelectionListenerAction implements IDisposable
{
	private IITestSuiteProvider testSuiteProvider;
	private IBlock block;
	private String baseName;
	private boolean actionPerformed = false;

	/**
	 * Constructor for AddBlockChildAction
	 * @param text
	 */
	public AddBlockChildAction(IITestSuiteProvider testSuiteProvider, String text, String baseName)
	{
		super(text);	
		this.testSuiteProvider = testSuiteProvider;
		this.baseName = baseName;
	}

	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		testSuiteProvider = null;
		block = null;
	}
	
	public String getBaseName()
	{
		return baseName;
	}

	/**
	 * Returns whether the most recent wizard has being completed or canceled.  This
	 * information is reset at the beging of an execution and when the selection 
	 * changes. 
	 * @return <code>true</code> if the wizard was completed or <code>false</code> if
	 * it was canceled.
	 */
	public boolean actionPerformed()
	{
		return actionPerformed;
	}
	
	protected void setActionPerformed(boolean actionPerformed)
	{
		this.actionPerformed = actionPerformed;
	}
	
	protected ITestSuite getTestSuite()
	{
		return testSuiteProvider.getTestSuite();
	}

	protected IBlock getBlock()
	{
		return block;
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		actionPerformed = false;
		block = null;
		if(structuredSelection.size() != 1)
			return false;
			
		Object object = structuredSelection.getFirstElement();
		if(object instanceof IBlock)
		{
			block = (IBlock)object;
		}
		else if(object instanceof ITest)
		{
			IImplementor implementor = ((ITest)object).getImplementor();
			if(implementor != null)
				block = implementor.getBlock();
		}
		else if(object instanceof IImplementor)
		{
			block = ((IImplementor)object).getBlock();
		}
		else if(object instanceof ILoop)
		{
			block = ((ILoop)object).getBlock();
		}
		
		return ((block != null) && (getTestSuite() != null));
	}	
}
