/*******************************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/package org.eclipse.hyades.test.common.internal.editor.action;

import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * @author CERVILLA
 *
 */
public class InsertBlockChildAction extends AddBlockChildAction {

	/**
	 * @param testSuiteProvider
	 * @param text
	 * @param baseName
	 */
	public InsertBlockChildAction(IITestSuiteProvider testSuiteProvider,
			String text, String baseName) {
		super(testSuiteProvider, text, baseName);
		// TODO Auto-generated constructor stub
	}
	
	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		if(structuredSelection.size() != 1)
			return false;
			
		Object object = structuredSelection.getFirstElement();
		if (object instanceof ITestSuite) {
			return false;
		}
		if(object instanceof ITestInvocation)
		{
			return true;
		}
		return super.updateSelection(structuredSelection);
	}	
}
