/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InsertLoop.java,v 1.2 2005/04/28 15:42:57 dguilbaud Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.editor.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.common.TestCommonImages;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;

/**
 * Adds a test case to the test suite and a test invocation to the block.
 * @author marcelop
 * @since 0.3.0
 */
public class InsertLoop 
extends InsertBlockChildAction
{
	
	/**
	 * Constructor for AddTestMethod
	 */
	public InsertLoop(IITestSuiteProvider testSuiteProvider, String text, String baseName)
	{
		super(testSuiteProvider, text, baseName);
		setImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor(TestCommonImages.IMG_LOOP));
	}

	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		IBlock parentBlock = null;
		// Find the parent block of the selection
		EObject objectSelection = (EObject)getStructuredSelection().getFirstElement();
		EObject parent = objectSelection.eContainer();
		if (parent != null && parent instanceof IBlock) {
			parentBlock = (IBlock)parent;
		} else {
			parentBlock = getTestSuite().getImplementor().getBlock();
		}
		
		if (parentBlock != null) {
			ILoop loop = HyadesFactory.INSTANCE.createLoop();
			loop.setName(TestCommonUtil.getUniqueName(getBaseName(), parentBlock.getActions(), ILoop.class));
			loop.getCondition().setConstraint("1"); //$NON-NLS-1$
			parentBlock.getActions().add(loop);
		}
	}
}
