/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCommonUtil.java,v 1.4 2005/03/15 14:52:07 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.internal.util;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.common.facades.behavioral.INamedElement;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestCommonUtil
{
	/**
	 * Returns a unique name based on the specified base and list of INamedElement.
	 * @param baseName
	 * @param namedElementList
	 * @return String
	 */
	public static String getUniqueName(String baseName, List namedElementList)
	{
		if(namedElementList == null)
			return baseName;
			
		return getUniqueName(baseName, namedElementList, namedElementList.size()+1);
	}

	/**
	 * Returns a unique name based on the specified base and list of INamedElement.
	 * If the element class parameter is different than null then the initial 
	 * number to be appended to the base name is equals to the number of instaces
	 * of this class in the list.    
	 * @param baseName
	 * @param namedElementList
	 * @param elementClass 
	 * @return String
	 */
	public static String getUniqueName(String baseName, List namedElementList, Class elementClass)
	{
		if(elementClass == null)
			return getUniqueName(baseName, namedElementList);
			
		int count = 1;
		for(Iterator i = namedElementList.iterator(); i.hasNext();)
		{
			if(elementClass.isInstance(i.next()))
				count++;
		}
		
		return getUniqueName(baseName, namedElementList, count);
	}

	/**
	 * Returns a unique name based on the specified base and list of INamedElement.  The
	 * initial number parameter is appended to the base name.
	 * @param baseName
	 * @param namedElementList
	 * @param initialNumber
	 * @return String
	 */
	public static String getUniqueName(String baseName, List namedElementList, int initialNumber)
	{
		if(namedElementList == null)
			return baseName;

		String[] args = new String[]{baseName, Integer.toString(initialNumber)};
		String name = TestCommonPlugin.getString("NME_CONCAT", args); //$NON-NLS-1$

		for (Iterator i = namedElementList.iterator(); i.hasNext();)
		{
			INamedElement namedElement = (INamedElement)i.next();
			if(name.equals(namedElement.getName()))
			{
				args[1] = Integer.toString(++initialNumber);
				name = TestCommonPlugin.getString("NME_CONCAT", args); //$NON-NLS-1$
				i = namedElementList.iterator();
			}
		}
		
		return name;
	}
	
	public static ITestCase createTestCase(ITestSuite testSuite, String type, boolean externalBehavior, String name)
	{
		ITestCase testCase = HyadesFactory.INSTANCE.createTestCase();
		((EObject)testCase).eAdapters().add(new TestCaseUniqueNameAdapter());
		testCase.setName(name);
		testCase.setType(type);
		
		testSuite.getITestCases().add(testCase);
		HyadesFactory.INSTANCE.createImplementor(testCase, externalBehavior);
		
		return testCase;
	}
	
	public static InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite, boolean singleSelection)
	{
		return new InvokedTestSelectionDialog(Display.getCurrent().getActiveShell(), testSuite, TestCommonPlugin.getString("DLG_INV_TST_TTL"), TestCommonPlugin.getString("DLG_LOCAL_TESTS_LBL"), TestCommonPlugin.getString("DLG_ALL_TESTS_LBL"), singleSelection) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		{
			protected void registerHelp(int flag, Object object)
			{
				switch(flag)
				{
					case HELP_DLG_CONTROL:
						WorkbenchHelp.setHelp((Control)object, TestCommonPlugin.getID() + ContextIds.INV_TEST_DLG);	
						break;
				
					case HELP_LOCAL_TEST_CASES_CONTROL:
						WorkbenchHelp.setHelp((Control)object, TestCommonPlugin.getID() + ContextIds.INV_TEST_METHD_DLG);				
						break;
				
					case HELP_TESTS_CONTROL:
						WorkbenchHelp.setHelp((Control)object, TestCommonPlugin.getID() + ContextIds.INV_TEST_SUITE_DLG);				
						break;
				}
			}
		};
	}	

}
