/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCaseNewWizard.java,v 1.5 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.NameAndDescriptionWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

/**
 * Wizard for test cases
 * 
 * @author marcelop
 * @since 1.0.2
 */
abstract public class TestCaseNewWizard extends HyadesWizard implements ITestCaseWizard {
    private NameAndDescriptionWizardPage nameAndDescriptionWizardPage;
    private ITestSuite testSuite;

    /**
     * Constructor for TestCaseNewWizard
     */
    public TestCaseNewWizard() {
        super();
        this.testSuite = null;
    }

    abstract protected String getType();

    /**
     * Returns the "name and description page" used by this wizard.
     * 
     * @return NameDescriptionWizardPage
     */
    protected NameAndDescriptionWizardPage getNameAndDescriptionWizardPage() {
        return nameAndDescriptionWizardPage;
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
     */
    protected void initPages() {
        nameAndDescriptionWizardPage = new NameAndDescriptionWizardPage("nameDescription"); //$NON-NLS-1$
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#performFinish()
     */
    public boolean performFinish() {
        ITestSuite ts = getTestSuite();
        if (ts != null) {
            ITestCase testCase = TestCommonUtil.createTestCase(ts, getType(), false, getNameAndDescriptionWizardPage().getItemName());
            testCase.setDescription(getNameAndDescriptionWizardPage().getItemDescription());
            SaveManager.saveResource((TPFTestSuite) ts);
            return true;
        }

        openErrorMessage(TestCommonPlugin.getString("word.Error")); //$NON-NLS-1$
        return false;
    }

    private void openErrorMessage(String message) {
        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), SWT.ICON_ERROR | SWT.OK | SWT.SYSTEM_MODAL);
        messageBox.setText(TestCommonPlugin.getString("error.NullTestSuite")); //$NON-NLS-1$
        messageBox.setMessage(message);
        messageBox.open();
    }

    /*
     * @see org.eclipse.hyades.test.ui.wizard.ITestCaseWizard#setTestSuite(org.eclipse.hyades.models.common.facades.behavioral.ITestSuite)
     */
    public void setTestSuite(ITestSuite ts) {
        this.testSuite = ts;
    }

    /**
     * @return Returns the testSuite.
     */
    public ITestSuite getTestSuite() {
        return this.testSuite;
    }
}
