/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.linux.internal;

import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LinuxHostDialog extends Dialog implements SelectionListener, KeyListener {

	String rac_host="localhost";
	boolean use_same = true;
	String reg_host="localhost";

	Composite host_panel;
		Label rac_host_label;
		Text rac_host_text;
//		Button reg_host_same;
//		Text reg_host_text;
	
	Composite buttonpanel;
	Button okbutton;
	Button cancelbutton;
	
	Shell parentshell;
	Shell thisshell;
	
	boolean complete[];
	
	public String getRACHost() {
		return rac_host;
	}
	public String getPerfmonHost() {
		if (use_same) {
			return rac_host;	
		} else {
			return reg_host;	
		}
	}
		
	public LinuxHostDialog (Shell parent) {
		super (parent, 0);
		this.parentshell = parent;
	}

	public Object open () {
		
		Shell parent = getParent();
		Shell shell = new Shell(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shell.setText(PerfmonPlugin.getString("CHOOSE_LINUX_HOST")); //$NON-NLS-1$
		shell.setBounds(0,0,400,150);
		shell.setLayout(new FillLayout());
		thisshell = shell;

		// Your code goes here (widget creation, set result, etc).

		PerfmonPlugin.DBG.info("initialising graphics");
		init(shell);
		shell.pack();

		Rectangle r = parentshell.getBounds();
		Rectangle z = shell.getBounds();
		if (z.width < 300) z.width = 300;
		if (z.height < 100) z.height = 100;

		shell.setBounds( r.x + (r.width/2) - (z.width/2),
						 r.y + (r.height/2) - (z.height/2),
						 z.width,
						 z.height
						 );
		

		PerfmonPlugin.DBG.info("opening dialog");
		shell.open();
		Display display = parent.getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) display.sleep();
		}
		
		//
		// get stuff from gui here
		//
		return null;
	}
	
	public void init(Shell parent) {

		GridLayout glayout = new GridLayout();
		glayout.numColumns = 1;

		Composite mainpanel = new Composite(parent,0);
		mainpanel.setLayout(glayout);
		
		glayout = new GridLayout();
		glayout.numColumns = 1;

		host_panel = new Composite(mainpanel,0);
		host_panel.setLayout(glayout);
		host_panel.setLayoutData(GData.getGridData(true,true,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
		rac_host_label = new Label(host_panel,SWT.LEFT);
		rac_host_label.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
//		Label hostlabel = new Label(host_panel, SWT.LEFT);
//		hostlabel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
		rac_host_text = new Text(host_panel,SWT.SINGLE|SWT.LEFT|SWT.BORDER);		
		rac_host_text.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		rac_host_label.setText(PerfmonPlugin.getString("RAC_HOST"));
		rac_host_text.setText(rac_host);
/*		
		reg_host_same = new Button(host_panel,SWT.CHECK);
		reg_host_same.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
		reg_host_text = new Text(host_panel,SWT.SINGLE|SWT.LEFT|SWT.BORDER);
		reg_host_text.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		reg_host_same.setText(PerfmonPlugin.getString("USE_RAC_HOST"));
		reg_host_text.setText(reg_host);

		reg_host_same.setSelection(false);
		reg_host_text.setEnabled(false);
*/
		glayout = new GridLayout();
		glayout.numColumns = 2;
		
		buttonpanel = new Composite(mainpanel,0);
		buttonpanel.setLayout(glayout);
		buttonpanel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.CENTER,GridData.FILL));
		
		okbutton = new Button(buttonpanel,0);
		okbutton.setText(" "+PerfmonPlugin.getString("OK")+" "); //$NON-NLS-1$
		okbutton.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.CENTER));

		cancelbutton = new Button(buttonpanel,0);
		cancelbutton.setText(PerfmonPlugin.getString("CANCEL")); //$NON-NLS-1$
		cancelbutton.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.CENTER));

//		reg_host_same.addSelectionListener(this);
		okbutton.addSelectionListener(this);
		cancelbutton.addSelectionListener(this);
		
		rac_host_text.addKeyListener(this);
//		reg_host_text.addKeyListener(this);
		
		//initialise to cancel values
		rac_host = null;
		reg_host = null;
		use_same = false;
	}
	
	public void keyPressed(KeyEvent e) {
	}
	public void keyReleased(KeyEvent e) {
		if (e.keyCode == SWT.CR) {
			widgetSelected(okbutton);
		}
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	} 
	public void widgetSelected(SelectionEvent e) {
		widgetSelected(e.getSource());	
	}
	public void widgetSelected(Object o) {
		if (o == okbutton) {
			PerfmonPlugin.DBG.info("OK selected");

			rac_host = rac_host_text.getText();
//			reg_host = reg_host_text.getText();
//			use_same = !reg_host_same.getSelection();

			thisshell.close();
		} else if (o == cancelbutton) {
			PerfmonPlugin.DBG.info("Cancel selected");

			rac_host = null;
			reg_host = null;
			use_same = false;

			thisshell.close();
//		} else if (o == reg_host_same) {
//			reg_host_text.setEnabled(!reg_host_text.getEnabled());
		}
	}  

}