/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.linux.internal.launchconfig;

import java.util.ArrayList;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.hyades.perfmon.linux.internal.LinuxConstants;
import org.eclipse.hyades.perfmon.utils.internal.launch.HostTab;

public class LinuxConfigTabGroup extends AbstractLaunchConfigurationTabGroup {

	public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
		ArrayList tabs = new ArrayList();
		tabs.add(new HostTab(LinuxConstants.AGENT_PREFIX));
        tabs.add(new LinuxMainTab()); 
        tabs.add(new CommonTab()); 

        ILaunchConfigurationTab[] alltabs = new ILaunchConfigurationTab[tabs.size()];
        tabs.toArray(alltabs); 
        setTabs(alltabs);
	}
	

	public void dispose() {
	}
}