/**********************************************************************
 * Copyright (c) 2003,2004,2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.perfmon.internal;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.common.internal.CommonCounterDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PerfmonProfileNavigatorExtension implements org.eclipse.hyades.ui.extension.INavigatorContribution {

class ConfigurePerfmonAction extends Action {
	Agent agent;
	TRCAgent trcagent;
	public ConfigurePerfmonAction(TRCAgent trcagent, Agent agent) {
		super(PerfmonPlugin.getString("CONFIGURE_PERFMON"),PerfmonPlugin.img.getImageDescriptor(ImageManager.IMG_PERFMON_LOGO));
		this.agent = agent;
		this.trcagent = trcagent;
	}
	public void run() {
		Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
		CommonCounterDialog dialog = new CommonCounterDialog(shell,trcagent,agent);
		
		dialog.open();
		
	}
}

	public void dispose() {
		//
	}

	public void fillContextMenu(IMenuManager menu, IStructuredSelection selections) {
		if (selections.size() > 1) return;
		if (selections.size() == 0) return;
		Object selection = selections.getFirstElement();
		
		if (selection instanceof TRCAgentProxy) {
			TRCAgentProxy aproxy = (TRCAgentProxy)selection;
//			TRCAgent agent = aproxy.getAgent();
//			PerfmonPlugin.DBG.info("SELECTED AGENT = "+agent);
//			agent.getProcess()

			Object obj = LoadersUtils.locateAgentInstance(aproxy);

			if (obj instanceof Agent) {
			
				Agent agent = (Agent)obj;
	
				if (agent != null) {
//					if (agent.getType().equals(PerfmonConstants.AGENT_PREFIX)) {
					TRCAgent trcagent = aproxy.getAgent();
					if (agent.getName().startsWith(PerfmonConstants.RAC_AGENT_PREFIX))
					{
//					if (trcagent.getName().startsWith(PerfmonConstants.AGENT_PREFIX)) {
						menu.add(new ConfigurePerfmonAction(trcagent,agent));
					}
				}
			
			}
			
			//need to somehow get a reference to the RAC node here (...execution.local.control)
			//richard - walk up the tree and get the session == connection?			
		}
	}
	
	public java.util.List getChildren(Object item) {
		return new ArrayList();
	}
	
	public Collection getModifiedItems() {
		return new ArrayList();
	}
	
	public boolean hasChildren(Object item) {
		return false;
	}

}