/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.perfmon.internal;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.common.internal.CommonModuleTrace;
import org.eclipse.hyades.perfmon.common.internal.CommonModuleTraceLaunchJob;
import org.eclipse.hyades.perfmon.utils.internal.JobLauncher;
import org.eclipse.hyades.statistical.ui.editor.internal.EntityExistsException;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModule;
import org.eclipse.hyades.statistical.ui.editor.internal.XMLConfigUtil;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PerfmonStatConModule implements StatConModule {

ArrayList traces = new ArrayList();

ImageManager img = PerfmonPlugin.img;

StatConInterface statcon;
boolean ica = false;
	
String PERFMON_NODE = "PERFMON_NODE_ID";

String NEW_TRACE = "NEW_TRACE_ID";
String NEW_ICA_TRACE = "NEW_ICA_TRACE_ID";

static String ACTION_SETSMODELPATH = "Set Statistical Model save path...";

URI smodelpath = null;

SimpleDateFormat smodel_sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");

	public PerfmonStatConModule() {
	}

	static String uriToHumanReadable(URI uri) {
		String path = uri.path();
		if (path.toLowerCase().startsWith("/resource/")) {
			path = path.substring(10);
		}
		return path;
	}
	
	private void redoActions() {
		statcon.addModuleNodeAction(PERFMON_NODE,ACTION_SETSMODELPATH,PerfmonPlugin.getString("ACTION_SETSMODELPATH")+" ("+uriToHumanReadable(smodelpath)+")", img.getImage(ImageManager.IMG_PERFMON_SAVE), new PerfmonSetPath());
	}	
	
	public void load(StatConInterface statcon) throws Exception {
		this.statcon = statcon;

		smodelpath = statcon.getCurrentProjectURI();
		
		//add a perfmon trace node
		try {
			statcon.addModuleNode(PerfmonPlugin.getString("DATACOLLECTION_NODE"),PerfmonPlugin.DATACOLLECTION_NODE_ID,img.getImage(ImageManager.IMG_PERFMON_LOGO));
		} catch (EntityExistsException e) {}
		statcon.addModuleNode(PerfmonPlugin.getString("PERFMON_NODE"),PERFMON_NODE,PerfmonPlugin.DATACOLLECTION_NODE_ID,img.getImage(ImageManager.IMG_PERFMON_HOST));
		statcon.addModuleNodeAction(PERFMON_NODE,NEW_TRACE,PerfmonPlugin.getString("NEW_TRACE"),img.getImage(ImageManager.IMG_PERFMON_START),new NewTraceAction());
//		statcon.addModuleNodeAction(PERFMON_NODE,NEW_ICA_TRACE,NEW_ICA_TRACE,img.getImage(ImageManager.IMG_PERFMON_START),new NewICATraceAction());		
		statcon.addModuleNodeAction(PERFMON_NODE,ACTION_SETSMODELPATH,PerfmonPlugin.getString("ACTION_SETSMODELPATH")+" ("+uriToHumanReadable(smodelpath)+")", img.getImage(ImageManager.IMG_PERFMON_SAVE), new PerfmonSetPath());

	}
	public void applyConfig(String xml) throws Exception {
		//do nothing
	}
	public void loadModuleData(byte[] dat) throws Exception {
		//read the statistical model URI from the statcon file, should really do this with XML

		PerfmonPlugin.DBG.info("loading perfmon module data: "+new String(dat));

		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setValidating(false);
		
		DocumentBuilder builder = factory.newDocumentBuilder();

		Document doc = builder.parse(new ByteArrayInputStream(dat));

		Element element = doc.getDocumentElement();

		ArrayList list = XMLConfigUtil.getAllElements(element.getChildNodes(),"config");
		
		IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

		for (int i = 0; i < list.size(); i++) {
			Element elem = (Element)list.get(i);
		
			String path = elem.getAttribute("smodelpath");
			if (path != null) {
				if (path.length() > 0) {
					try {
						IFile tfile = workspaceRoot.getFile(new Path(path));
						smodelpath = URI.createPlatformResourceURI(tfile.getProjectRelativePath().toString());
					} catch (Throwable x) {
						PerfmonPlugin.DBG.info("invalid valid statistical model save path specified");
					}
				}	
			}	
		}
		
		redoActions();
	}
	public byte[] saveModuleData() throws Exception {
		//save the statistical model URI to the statcon file, should be XML
		
		StringBuffer xml = new StringBuffer();
		xml.append("<perfmon_config>\n");
		xml.append("  <config smodelpath=\""+smodelpath+"\" />\n");
		xml.append("</perfmon_config>\n");
		
		PerfmonPlugin.DBG.info("saving perfmon module data:"+xml);
		
		return xml.toString().getBytes();
	}

	public String getModuleRef() {
		return "org.eclipse.hyades.perfmon";
	}	
	
	public void unload() throws Exception {
		statcon.removeModuleNode(PERFMON_NODE);
		
		for (int i = 0; i < traces.size(); i++) {
			Object t = traces.get(i);
/*			if (t instanceof ICAModuleTrace)
			{
				ICAModuleTrace trace = (ICAModuleTrace) t;
				try {
					trace.unloadTrace();
				} catch (Exception e) {
					PerfmonPlugin.DBG.warning("failed to unload trace "+i);
				}					
			}
			else
*/			{
				CommonModuleTrace trace = ((CommonModuleTraceLaunchJob)t).getModuleTrace();
				try {
					trace.unloadTrace();
				} catch (Exception e) {
					PerfmonPlugin.DBG.warning("failed to unload trace "+i);
				}					
			}			
		}
	}
	
	class PerfmonSetPath implements Runnable {
		public void run() {
			PerfmonPlugin.DBG.info("set test model save path");

			IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
			Path container_savepath = null;
			IContainer container = null;
			try {
				container_savepath = new Path(""+smodelpath);
				container = workspaceRoot.getFolder(container_savepath);
			} catch (Throwable e) {
				PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path");
			}

			PerfmonPlugin.DBG.info("showing container selection dialog");
			//pop up a dialog	
			ContainerSelectionDialog dialog = null;
			dialog = new ContainerSelectionDialog(statcon.getGraphWindow().getShell(), container, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
			dialog.open();
			Object[] result = dialog.getResult();

			if (result != null) {			
				if (result.length > 0) {

					Path container_path = (Path)result[0];
					URI savepath = URI.createPlatformResourceURI(container_path.toString());

					smodelpath = savepath;

					PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
					
					redoActions();
					statcon.setDirty(true);
				}
			}
		}
			
	}
	
	
	public void startPerfmonTrace(String rac_host, String reg_host, URI smodel_path) {
		
		PerfmonModuleTrace trace = new PerfmonModuleTrace(statcon,rac_host,reg_host,smodel_path,null);

		CommonModuleTraceLaunchJob job = new CommonModuleTraceLaunchJob(PerfmonPlugin.getString("PROGRESS_LAUNCHING"),trace);
		JobLauncher.launch(job);

		traces.add(job);
	}
	
	class NewTraceAction implements Runnable {
		public void run() {
			
			try {

				//pop up a dialog here
				
				PerfmonHostDialog dialog = new PerfmonHostDialog(statcon.getGraphWindow().getShell());
				dialog.open();
				
				String rac_host = dialog.getRACHost();
				String reg_host = dialog.getPerfmonHost();
				
				if (rac_host == null) return;

				startPerfmonTrace(rac_host,reg_host,smodelpath);
			} catch (Throwable t) {
				PerfmonPlugin.DBG.error("error starting perfmon trace",t);	
			}
			
		}
	}
	
/*	class NewICATraceAction implements Runnable {
		public void run() {			
			try {

				//pop up a dialog here
				ICADialog dialog = new ICADialog(statcon.getGraphWindow().getShell());
				CitrixConnectionInfo cinfo = (CitrixConnectionInfo)dialog.open();
				if (cinfo == null) {
					return;
				}

				PerfmonPlugin.DBG.info(cinfo);
				
				ICAModuleTrace trace = new ICAModuleTrace(statcon, cinfo.username, cinfo.password, cinfo.host, cinfo.workingdir, cinfo.hres, cinfo.vres, smodelpath);
				traces.add(trace);
				
			} catch (Throwable t) {
				PerfmonPlugin.DBG.logVisibleError(t,PerfmonPlugin.getString("ERROR_STARTING_TRACE"),true);	
			}
			
		}
	}
*/
	
}