/**********************************************************************
 * Copyright (c) 2003,2004,2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.perfmon.utils.internal.launch;

import java.net.UnknownHostException;

import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class HostUI extends HostUpdater implements SelectionListener, ModifyListener
{
	private Button _delete;
	private Button _add;
	private Text   _host;
	private Text   _port;
	private Table  _list;
	
	private String DEFAULT_PORT = "10002";
	private String agentname;

public HostUI(String agentname) {
	super();
	this.agentname = agentname;
}

/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 4:09:19 PM)
 */
public void addHost()
{
	addHost(_host.getText().trim() + ":" + _port.getText().trim());
	_host.setText("");
	_port.setText(DEFAULT_PORT);
	_host.setFocus();
}

/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 5:17:57 PM)
 * @param text java.lang.String
 */
public void addHost(String text)
{
	for(int idx=0; idx<_list.getItemCount(); idx++)
	{
		if (text.equals(_list.getItem(idx).getText()))
			return;
	}
	
	TableItem item = new TableItem(_list, SWT.NONE);
	item.setText(text);
	item.setImage(PerfmonPlugin.img.getImage(ImageManager.IMG_LC_NODE));

	_list.setSelection(new TableItem[] {item});
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 12:10:51 PM)
 * @param hosts java.lang.String
 */
private void addHosts(String hosts)
{
	//since I only get called upon initialization
	// I will remove all the previous hosts
	//and then add these hosts
	if(hosts != null && !hosts.equals(""))
	{
	   int idx = 0;

	   while(idx != -1)
	   {
		   idx = hosts.indexOf(",");

		   if(idx != -1)
		   {
			   String host = hosts.substring(0, idx);
			   addHost(host);

			   hosts = hosts.substring(idx+1);
			   
		   }
		   else
		   {
			   addHost(hosts);             
		   }
	   }
	}
	
}



public Composite createControl(Composite parent)
{
	GridData   data = new GridData();
	Composite result = new Composite(parent, SWT.NONE);	
	GridLayout layout = new GridLayout();
	layout.numColumns = 3;
	layout.verticalSpacing=10;
	result.setLayout(layout);
	result.setLayoutData(new GridData(GridData.FILL_BOTH));	
	
		Label desc = new Label(result, SWT.NULL);
		GridData data2 = new GridData(GridData.FILL_HORIZONTAL);
		data2.horizontalSpan = 3;		   
		desc.setLayoutData(data2);
		desc.setText(PerfmonPlugin.getString("STR_PREF_HOST_NODE"));
		
	    Composite dataGroup = new Composite(result, SWT.NULL);
		GridLayout layout2 = new GridLayout(1,false);
		layout2.numColumns = 1;
		layout2.verticalSpacing=10;
		dataGroup.setLayout(layout2);
		dataGroup.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		_list = new Table(dataGroup, SWT.BORDER|SWT.H_SCROLL);
		_list.setLayoutData(new GridData(GridData.FILL_BOTH));
		
			Composite bottomWidget = new Composite (dataGroup, SWT.NULL);	
			bottomWidget.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));     
			GridLayout layout3 = new GridLayout();
			layout3.numColumns = 2;
			bottomWidget.setLayout(layout3);
			
				Label hostLabel = new Label(bottomWidget, SWT.NULL);
				hostLabel.setText(PerfmonPlugin.getString("STR_PREF_HOST_IP"));
				_host = new Text(bottomWidget, SWT.BORDER);
				_host.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				
				Label portLabel = new Label(bottomWidget, SWT.NULL);
				portLabel.setText(PerfmonPlugin.getString("RAC_PORT_TEXT"));
			
				_port = new Text(bottomWidget, SWT.BORDER);	
				_port.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				_port.setText(DEFAULT_PORT);
				
	Composite buttonWidget = new Composite (result, SWT.NULL);
	buttonWidget.setLayoutData(new GridData(GridData.FILL_VERTICAL | GridData.HORIZONTAL_ALIGN_FILL));
	GridLayout layout4 = new GridLayout();
	layout4.numColumns = 1;
	buttonWidget.setLayout(layout4);     

	Composite buttonWidget1 = new Composite (buttonWidget, SWT.NULL);
	buttonWidget1.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));    
	GridLayout layout5 = new GridLayout();
	layout5.numColumns = 1;
	buttonWidget1.setLayout(layout5);     
	
	_delete = new Button(buttonWidget1, SWT.NULL);	
	_delete.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	_delete.setText("     "+PerfmonPlugin.getString("DELETE")+"     ");

	Label l = new Label(buttonWidget1, SWT.NULL);
	l.setLayoutData(new GridData(GridData.FILL_VERTICAL));

	Composite buttonWidget2 = new Composite (buttonWidget, SWT.NULL);
	GridLayout layout6 = new GridLayout();
	layout6.numColumns = 1;
	buttonWidget2.setLayout(layout6);     
	buttonWidget2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));

	_add = new Button(buttonWidget2, SWT.NULL);
	_add.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));    
	_add.setText(PerfmonPlugin.getString("STR_PREF_ADD"));

	_add.addSelectionListener(this);
	_delete.addSelectionListener(this);
	_list.addSelectionListener(this);

	_host.addModifyListener(this);
	_port.addModifyListener(this);

	_add.setEnabled(false);
	_delete.setEnabled(false);

	initializeValues();

	_host.setFocus();
	
	_host.addTraverseListener(new TraverseListener()
		{
				public void keyTraversed(TraverseEvent e)
				{
						if (e.detail == SWT.TRAVERSE_RETURN)
						{
								if (_host.getText().trim()=="" || _port.getText().trim()=="")
									return;
									
			 				    addHost();	                        
								e.doit = false;
								
						}
				}
		});

	return result;
}

public Table getListUI()
{
	return _list;
}

public Text getHostUI()
{
	return _host;
}

public Text getPortUI()
{
	return _port;
}

public Button getDeleteUI()
{
	return _delete;
}
public Button getAddUI()
{
	return _add;
}

/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 4:09:39 PM)
 */
private void deleteHost()
{
   int i = _list.getSelectionIndex();
   if(i != -1)
	 _list.remove(i);

}

/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 12:30:45 PM)
 * @return java.lang.String
 */
public String getHost()
{
	String name = null;
	int idx = _list.getSelectionIndex();

	if (idx != -1)
		name = _list.getItem(idx).getText();
	else
		return name;

	int id = name.indexOf(":");
	if (id != -1) {
		name = name.substring(0, id);
	}

	return name;
}

public int getPort()
{
	String port = DEFAULT_PORT;

	int idx = _list.getSelectionIndex();
	if(idx != -1)
		port = _list.getItem(idx).getText();
		
		int id = port.indexOf(":");
		if (id != -1) 
			port = port.substring(id + 1);
		else
			port = DEFAULT_PORT;
	
	return Integer.parseInt(port);
}
/*
 * 
 */
public boolean isLocalHost(String hostname)
{
	String name = "localhost";
	if (name.equals(hostname))
		return true;
	
	try 
	{
		  Node fnode = NodeFactory.createNode(name);
		  name = fnode.getInetAddress().getHostName();
	}
	catch(UnknownHostException exc)
	{
		return false;
	}

    if(hostname.equals(name))
      return true;
	
	return false;
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:21:50 AM)
 * @return com.ibm.swt.widgets.TableItem[]
 */
public TableItem[] getHosts() {
	return _list.getItems();
}
/**
 * Initializes states of the controls from the preference store.
 */
private void initializeValues()
{
	IPreferenceStore store = PerfmonPlugin.getDefault().getPreferenceStore();    

	String hosts = store.getString(HostTab.HOSTNAME+agentname);
	addHosts(hosts);
	enableButtons();
}
/**
 * Sent when the text is modified.
 *
 * @param e an event containing information about the modify
 */
public void modifyText(ModifyEvent e)
{
	if(e.widget == _host)
	   _add.setEnabled((!_host.getText().trim().equals("")) && (!_port.getText().trim().equals("")));
	else if (e.widget == _port)
	{
	   try {
			int value = Integer.parseInt(_port.getText().trim());
			if (value<0 || value>65535)
			{
				_add.setEnabled(false);
				return;
			}
			    _add.setEnabled((!_host.getText().trim().equals("")) && (!_port.getText().trim().equals("")));
		} catch (NumberFormatException nfe) {
			_add.setEnabled(false);
		}
	  
	}
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 12:16:48 PM)
 */
public void reset()
{
	_list.removeAll();
}
/**
 * Sent when default selection occurs in the control.
 * <p>
 * For example, on some platforms default selection occurs
 * in a List when the user double-clicks an item or types
 * return in a Text.
 * </p>
 *
 * @param e an event containing information about the default selection
 */
public void widgetDefaultSelected(SelectionEvent e)
{
}

private void enableButtons()
{
	_delete.setEnabled(_list.getSelectionIndex() != -1);
}
/**
 * Sent when selection occurs in the control.
 * <p>
 * For example, on some platforms selection occurs in
 * a List when the user selects an item or items.
 * </p>
 *
 * @param e an event containing information about the selection
 */
public void widgetSelected(SelectionEvent e)
{	
	if(e.widget == _add)
	{
	  addHost();
	  enableButtons();
	  changed();	  
	}
	else if(e.widget == _delete)
	{
	  deleteHost();
	  enableButtons();
	  changed();	 
	}
	else if(e.widget == _list)
	{  
	   TableItem[] selected = _list.getSelection();
	   enableButtons();
	   _list.setSelection(selected);
	   changed();
	}   	
}


public void selectHost(String hostname)
{
	for(int idx=0; idx<_list.getItemCount(); idx++) {
		if (hostname.equals(_list.getItem(idx).getText())) {
			_list.setSelection(idx);
			return;
		}
	}
}
}
