/**********************************************************************
 * Copyright (c) 2003,2004,2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.perfmon.utils.internal.launch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class HostUpdater
{
	private static final Event EVENT = new Event();
	private final List _listeners = new ArrayList();

	public void addListener(Listener l)
	{
		synchronized(_listeners)
		{
			_listeners.add(l);
		}
	}

	public void removeListener(Listener l)
	{
		synchronized(_listeners)
		{
			_listeners.remove(l);
		}
	}

	protected void changed()
	{
		synchronized(_listeners)
		{
			Iterator i = _listeners.iterator();
			while (i.hasNext())
				((Listener)i.next()).handleEvent(EVENT);
		}
	}
}
