/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CallStackPerThread.java,v 1.6 2005/02/16 22:21:26 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: CallStackPerThread.java,v 1.6 2005/02/16 22:21:26 qiyanli Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;


/**
 * The current call stack for a thread
 *
 * @author slavescu
 *
 */
public class CallStackPerThread extends Stack {
	protected Map locks=new HashMap();
	protected Map locksInherited=new HashMap();
	protected TraceUtils.InvocationPool	invocationPool=new TraceUtils.InvocationPool();
	
	public Map getLocks() {
		return locks;
	}

	public Map getLocksInherited() {
		return locksInherited;
	}

	public TraceUtils.InvocationPool getInvocationPool() {
		return invocationPool;
	}

	public void setInvocationPool(TraceUtils.InvocationPool pool) {
		invocationPool = pool;
	}

	public void setLocks(Map map) {
		locks = map;
	}

	public void setLocksInherited(Map map) {
		locksInherited = map;
	}

}
