/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TRCObjectEntry.java,v 1.4 2005/02/16 22:21:27 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: TRCObjectEntry.java,v 1.4 2005/02/16 22:21:27 qiyanli Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.models.trace.TRCObject;

/**
 * @author slavescu
 */
public class TRCObjectEntry {
	private TRCObject[] data;
	/**
	 *
	 */

	public TRCObjectEntry() {
		super();
	}

	public TRCObject get(Class type)
	{
		if(data!=null)
		{
			for (int i = 0; i < data.length; i++) {
				if(((TRCObject)data[i]).getClass()==type)
					return data[i];
			}
		}
		return null;
	}
	public boolean put(Class type, TRCObject value)
	{
		if(data!=null)
		{
			for (int i = 0; i < data.length; i++) {
				if(((TRCObject)data[i]).getClass()==type)
				{
					data[i]=value;
					return true;
				}
			}
		}
		addValue(value);
		return false;
	}
	private void addValue(TRCObject value) {
		if(data==null)
		{
			data = new TRCObject[1];
			data[0]=value;
		}
		else
		{
			TRCObject[] newArray = new TRCObject[data.length+1];
			System.arraycopy(data,0,newArray,0,data.length);
			newArray[data.length]=value;
			data = newArray;
		}
	}
	public boolean remove(Class type)
	{
		if(data!=null)
		{
			for (int i = 0; i < data.length; i++) {
				if(((TRCObject)data[i]).getClass()==type)
				{
					remove(i);
					return true;
				}
			}
		}
		return false;
	}
	private void remove(int i) {
		if(data.length==1)
		{
			data=null;
			return;
		}
		TRCObject[] newArray = new TRCObject[data.length-1];
		System.arraycopy(data,0,newArray,0,i);
		System.arraycopy(data,i+1,newArray,i,data.length-i);
		data = newArray;
	}
	public int getId() {
		if(data!=null)
		{
			if(data.length>0)
				data[0].getId();
		}
		return -1;
	}
}
