/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLmethodInvocationsLoader.java,v 1.13 2005/05/04 13:42:25 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLmethodInvocationsLoader.java,v 1.13 2005/05/04 13:42:25 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import java.util.Iterator;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;

/**
 * @author slavescu
 * @since 3.2
 */
public class XMLmethodInvocationsLoader extends TraceXMLFragmentLoader {
	protected static final String MIN_VALUE = "minValue";

	protected static final String MAX_VALUE = "maxValue";

	protected static final String MIN_TIME = "minTime";

	protected static final String MAX_TIME = "maxTime";

	protected static final String TOTAL_TIME = "totalTime";

	protected static final String COUNT = "count";

	protected double minTime; // added to aggregated invocation
	
	protected double maxTime; // added to aggregated invocation

	protected double totalTime; // added to cumulative time

	protected int count; // added to calls

	protected TRCAggregatedMethodInvocation invocation;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader#addAttribute(java.lang.String,
	 *      java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		if (!loadToModel) {
			return;
		}
		switch (LoadersUtils.getHashCode(name)) {
		case TraceConstants.MIN_TIME_int:
		case TraceConstants.MIN_VALUE_int:
			minTime = Double.parseDouble(value);
			break;
		case TraceConstants.MAX_TIME_int:
		case TraceConstants.MAX_VALUE_int:
			maxTime = Double.parseDouble(value);
			break;
		case TraceConstants.TOTAL_TIME_int:
			totalTime = Double.parseDouble(value);
			break;
		case TraceConstants.COUNT_int:
			count = Integer.parseInt(value);
			break;
		default:
			super.addAttribute(name, value);
			break;
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCMethod_Name(),LoadersUtils.getLookUpKey(methodIdRef)))
			{
				return;
			}
		}
		
		if (!loadToModel) {
			return;
		}
		theProcess = getProcess();
		Class clazz = TraceUtils.isBooleanOptionEnabled(context,
				Constants.LLDATA_ENABLED) ? TRCMethodWithLLDataImpl.class
				: TRCMethodImpl.class;
		theMethod = (TRCMethod) LookupServiceExtensions.getInstance().locate(
				context, clazz, LoadersUtils.getLookUpKey(methodIdRef));
		if (theMethod == null)
			return;
		
		if(maxTime!=0)
			getAggregatedInvocation().setMaxTime(maxTime);
		if(minTime!=0)
			getAggregatedInvocation().setMinTime(minTime);
		if(totalTime!=0)
		{
			theMethod.setCumulativeTime(theMethod.getCumulativeTime()+totalTime);
			theMethod.getDefiningClass().setCumulativeTime(theMethod.getDefiningClass().getCumulativeTime()+totalTime);
			theMethod.getDefiningClass().getPackage().setCumulativeTime(theMethod.getDefiningClass().getPackage().getCumulativeTime()+totalTime);
			theProcess.setCumulativeTime(theProcess.getCumulativeTime()+totalTime);
			if(invocation!=null)
				invocation.setCumulativeTime(totalTime);
		}
		if(count!=0)
		{
			if(invocation!=null)
			{	
				theMethod.setCalls(theMethod.getCalls()+count);
				theMethod.getDefiningClass().setCalls(theMethod.getDefiningClass().getCalls()+count);
				theMethod.getDefiningClass().getPackage().setCalls(theMethod.getDefiningClass().getPackage().getCalls()+count);
				theProcess.setCalls(theProcess.getCalls()+count);
				invocation.setCount(count);
			}
			else if(count > theMethod.getCalls())
			{
				theMethod.setCalls(count);
				theMethod.getDefiningClass().setCalls(theMethod.getDefiningClass().getCalls()+count);
				theMethod.getDefiningClass().getPackage().setCalls(theMethod.getDefiningClass().getPackage().getCalls()+count);
				theProcess.setCalls(theProcess.getCalls()+count);
			}
		}
	}

	protected TRCAggregatedMethodInvocation getAggregatedInvocation() {
		if(invocation != null)
		{
			return invocation;
		}
		for (Iterator iter = theMethod.getInvocations().iterator(); iter.hasNext();) {
			TRCMethodInvocation element = (TRCMethodInvocation) iter.next();
			if(element instanceof TRCAggregatedMethodInvocation)
			{
				invocation = (TRCAggregatedMethodInvocation)element;
				break;
			}
		}
		
		if(invocation == null)
		{
			invocation = TraceFactory.eINSTANCE.createTRCAggregatedMethodInvocation();
			theMethod.getInvocations().add(invocation);
			theProcess.getInvocations().add(invocation);
		}
		return invocation;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext,
	 *      java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		if (!loadToModel) {
			return;
		}
		super.initialize(context, name);
		minTime = 0;
		maxTime = 0;
		totalTime = 0;
		count = 0;
		invocation = null;
		
	}
}