/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLmonWaitLoader.java,v 1.11 2005/03/18 22:42:07 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLmonWaitLoader.java,v 1.11 2005/03/18 22:42:07 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
public class XMLmonWaitLoader extends TraceXMLFragmentLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	protected static final String TIMEOUT = "timeout";
	//~ Instance fields
	// ----------------------------------------------------------------------------
	protected long timeout;
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.TIMEOUT_int :
				timeout = Long.parseLong(value);
				break;
			default :
				super.addAttribute(name, value);
				break;
		}
	}
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		if (objIdRef == -1) {
			TRCThreadSleepingEvent sleepingEvent = TraceFactory.eINSTANCE.createTRCThreadSleepingEvent();
			sleepingEvent.setSleepingTime(timeout);
			sleepingEvent.setTime(createDeltaTime());//time);
			sleepingEvent.setThread(theThread);
			theThread.getThreadEvents().add(sleepingEvent);
		} else {
			dispatchProcessMode(ProcessSteps.ALL);
			TRCThreadWaitingForObjectEvent threadWaitingForObjectEvent = TraceFactory.eINSTANCE.createTRCThreadWaitingForObjectEvent();
			threadWaitingForObjectEvent.setObjectWaitingFor(theObject);
			threadWaitingForObjectEvent.setThread(theThread);
			threadWaitingForObjectEvent.setTime(createDeltaTime());//time);
			threadWaitingForObjectEvent.setTimeout(timeout);
			theThread.getThreadEvents().add(threadWaitingForObjectEvent);
		}
	}
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		super.initialize(context, name);
		timeout = 0;
	}
	protected void processEF(int step) {
		super.processEF(step);
		if ((theObject == null) || !(theObject instanceof TRCFullTraceObject)) {
			theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, LoadersUtils.getLookUpKey(objIdRef));
		}
	}
	/**
	 *  
	 */
	protected void processES(int step) {
		super.processES(step);
		if (objIdRef > 0) {
			virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, LoadersUtils.getLookUpKey(objIdRef));
			if (virtualObject != null) {
				theObject = getClassObject(virtualObject.myClass, TRCFullTraceObjectImpl.class);
			} else {
				return;
			}
		} else {
			theObject = getClassObject(theClass, TRCFullTraceObjectImpl.class);
		}
	}
	/**
	 *  
	 */
	protected void processHF(int step) {
		super.processHF(step);
		Class clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class);
		if ((theObject == null) || !(theObject instanceof TRCHeapObject)) {
			theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, clazz, LoadersUtils.getLookUpKey(objIdRef));
		}
	}
}