/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLmonWaitedLoader.java,v 1.6 2005/03/18 22:42:07 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLmonWaitedLoader.java,v 1.6 2005/03/18 22:42:07 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
public class XMLmonWaitedLoader extends XMLmonWaitLoader {
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}
		// TODO MS - timeout is not used and has a different meaning here
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		TRCThreadRunningEvent runningEvent = TraceFactory.eINSTANCE.createTRCThreadRunningEvent();
		runningEvent.setTime(createDeltaTime());//time);
		theThread.getThreadEvents().add(runningEvent);
	}
	protected void processEF(int step) {
	}
	protected void processES(int step) {
	}
	protected void processHF(int step) {
	}
}