/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterInternalMessages.java,v 1.6 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;

/**
 * @author sveyrier
 *
 */
public class FilterInternalMessages extends Action {

	private SDView view = null;
	
	public FilterInternalMessages(SDView theView)
	{
		super(SDViewerPlugin.getResourceString("ACTION_FILTER_INT_NAME"),AS_CHECK_BOX); //$NON-NLS-1$
		view = theView;
		setToolTipText(SDViewerPlugin.getResourceString("ACTION_FILTER_INT_DESCRIPTION")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.filterinternalmesssage"); //$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("filter_obj.gif")); //$NON-NLS-1$
	}
	
	public void run()
	{
		if ((view==null)||(view.getSDWidget())==null)
			return;
		if (view.getInternalMessageFilterProvider()!= null)
			view.getInternalMessageFilterProvider().setInternalMessageFiltered(isChecked());
		//view.getSDWidget().redraw();
	}
}
