/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NextPage.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;

/**
 * @author sveyrier
 *
 */
public class NextPage extends Action{
	
	private SDView view = null;
	
	public NextPage(SDView theView)
	{
		super();
		view = theView;
		setText(SDViewerPlugin.getResourceString("COOLBAR_NEXT_PAGE")); //$NON-NLS-1$
		setToolTipText(SDViewerPlugin.getResourceString("COOLBAR_NEXT_PAGE_TOOLTIP")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.nextpage"); //$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("next_nav.gif")); //$NON-NLS-1$
	}

	public void run()
	{
		if ((view==null)||(view.getSDWidget())==null)
			return;
		if (view.getSDPagingProvider()!=null)
			view.getSDPagingProvider().nextPage();
		view.updateCoolBar();
		view.getSDWidget().redraw();
	}
}
