/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenSDFiltersDialog.java,v 1.9 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.FilterListDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;

/**
 * Action delegate for 'Filter' on a message
 */
public class OpenSDFiltersDialog extends Action {

	private SDView view;	
	private ISDFilterProvider provider;

	/**
	 * @param view_
	 */
	public OpenSDFiltersDialog(SDView view_, ISDFilterProvider provider_) {
		super(SDViewerPlugin.getResourceString("POPUP_MENU_FILTER"));//$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("filter_obj.gif")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.sdFilters"); //$NON-NLS-1$
		setToolTipText(SDViewerPlugin.getResourceString("POPUP_MENU_FILTER"));//$NON-NLS-1$
		view = view_;
		provider = provider_;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		if (view == null) {
			return;
		}
		FilterListDialog dialog = new FilterListDialog(view, provider);
		dialog.open();
	}
}
