/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenSDFindDialog.java,v 1.8 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.SearchFilterDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;

/**
 * @author sveyrier
 *
 */
public class OpenSDFindDialog extends Action{
	
	private SDView view = null;
	
	public OpenSDFindDialog(SDView theView)
	{
		super(SDViewerPlugin.getResourceString("POPUP_MENU_FIND"));//$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("search_seqdiag_co.gif")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.sdFind"); //$NON-NLS-1$
		setToolTipText(SDViewerPlugin.getResourceString("POPUP_MENU_FIND"));//$NON-NLS-1$
		view = theView;
	}

	public void run()
	{
		if (view == null)
			return;
		if ((view.getExtendedFindProvider()!=null)&&(view.getExtendedFindProvider().getFindAction()!=null))
		{
			view.getExtendedFindProvider().getFindAction().run();
		}
		else if (view.getSDFindProvider()!=null)
		{
			SearchFilterDialog dialog = new SearchFilterDialog(view, view.getSDFindProvider(), false, SWT.NORMAL);
			dialog.open();
		}
	}
}
