/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenSDPagesDialog.java,v 1.8 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.PagesDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;

/**
 * Action delegate for 'Filter' on a message
 */
public class OpenSDPagesDialog extends Action {

	public static final String ACTIONID_SDPAGING = "org.eclipse.hyades.uml2sd.ui.sdPaging"; //$NON-NLS-1$
	private SDView view;	
	private ISDAdvancedPagingProvider provider;

	/**
	 * @param view_
	 */
	public OpenSDPagesDialog(SDView view_, ISDAdvancedPagingProvider provider_) {
		super(SDViewerPlugin.getResourceString("POPUP_MENU_PAGES"));//$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("gotopage.gif")); //$NON-NLS-1$
		setId(ACTIONID_SDPAGING);
		view = view_;
		provider = provider_;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		if (view == null) {
			return;
		}
		PagesDialog dialog = new PagesDialog(view, provider);
		dialog.open();
	}
}
