/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ShowNodeStart.java,v 1.7 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import java.util.Iterator;

import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;

/**
 * @author sveyrier
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ShowNodeStart extends Action {
		
	protected SDView viewer = null;
	
	public ShowNodeStart (IViewPart view)
	{
		if (view instanceof SDView)
			viewer = (SDView)view;
	}
	
	public void run ()
	{
		if (viewer == null)
			return;
		SDWidget sdWidget = viewer.getSDWidget();
		
		ISelectionProvider selProvider = sdWidget.getSelectionProvider();
		ISelection sel=selProvider.getSelection();
		Object selectedNode= null;
		Iterator  it = ((StructuredSelection)sel).iterator();
		while (it.hasNext())
			selectedNode = it.next();
		if (selectedNode != null)
		{
			GraphNode node = (GraphNode)selectedNode;
			if (node.getX()*sdWidget.getZoomFactor()<sdWidget.getContentsX()+sdWidget.getVisibleWidth()/2)
				sdWidget.ensureVisible(Math.round(node.getX()*sdWidget.getZoomFactor()-sdWidget.getVisibleWidth()/2),
						Math.round(node.getY()*sdWidget.getZoomFactor()));
			else sdWidget.ensureVisible(Math.round(node.getX()*sdWidget.getZoomFactor()+sdWidget.getVisibleWidth()/2),
					Math.round(node.getY()*sdWidget.getZoomFactor()));
		}
	}
}
